/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;

public class ModifyCraftingPower
extends ValueModifyingPower {
    private final ResourceLocation recipeIdentifier;
    private final Predicate<ItemStack> itemCondition;
    private final ItemStack newStack;
    private final Consumer<Tuple<Level, ItemStack>> itemAction;
    private final Consumer<Tuple<Level, ItemStack>> lateItemAction;
    private final Consumer<Entity> entityAction;
    private final Consumer<Triple<Level, BlockPos, Direction>> blockAction;

    public ModifyCraftingPower(PowerType<?> type, LivingEntity entity, ResourceLocation recipeIdentifier, Predicate<ItemStack> itemCondition, ItemStack newStack, Consumer<Tuple<Level, ItemStack>> itemAction, Consumer<Tuple<Level, ItemStack>> lateItemAction, Consumer<Entity> entityAction, Consumer<Triple<Level, BlockPos, Direction>> blockAction) {
        super(type, entity);
        this.recipeIdentifier = recipeIdentifier;
        this.itemCondition = itemCondition;
        this.newStack = newStack;
        this.itemAction = itemAction;
        this.lateItemAction = lateItemAction;
        this.entityAction = entityAction;
        this.blockAction = blockAction;
    }

    public boolean doesApply(TransientCraftingContainer inventory, CraftingRecipe recipe) {
        if (this.recipeIdentifier != null && !recipe.m_6423_().equals((Object)this.recipeIdentifier)) {
            return false;
        }
        return this.itemCondition == null || this.itemCondition.test(recipe.m_5874_((Container)inventory, this.entity.m_9236_().m_9598_()));
    }

    public void applyAfterCraftingItemAction(ItemStack output) {
        if (this.lateItemAction == null) {
            return;
        }
        this.lateItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)output));
    }

    public ItemStack getNewResult(TransientCraftingContainer inventory, CraftingRecipe recipe) {
        ItemStack stack = this.newStack != null ? this.newStack.m_41777_() : recipe.m_5874_((Container)inventory, this.entity.m_9236_().m_9598_());
        if (this.itemAction != null) {
            this.itemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)stack));
        }
        return stack;
    }

    public void executeActions(Optional<BlockPos> craftingBlockPos) {
        if (craftingBlockPos.isPresent() && this.blockAction != null) {
            this.blockAction.accept((Triple<Level, BlockPos, Direction>)Triple.of((Object)this.entity.m_9236_(), (Object)craftingBlockPos.get(), (Object)Direction.UP));
        }
        if (this.entityAction != null) {
            this.entityAction.accept((Entity)this.entity);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_crafting"), new SerializableData().add("recipe", SerializableDataTypes.IDENTIFIER, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("result", SerializableDataTypes.ITEM_STACK, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("item_action_after_crafting", ApoliDataTypes.ITEM_ACTION, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("block_action", ApoliDataTypes.BLOCK_ACTION, null), data -> (type, player) -> new ModifyCraftingPower((PowerType<?>)type, (LivingEntity)player, data.getId("recipe"), (Predicate)data.get("item_condition"), (ItemStack)data.get("result"), (Consumer)data.get("item_action"), (Consumer)data.get("item_action_after_crafting"), (Consumer)data.get("entity_action"), (Consumer)data.get("block_action"))).allowCondition();
    }
}

