/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class KeepInventoryPower
extends Power {
    private final Predicate<ItemStack> keepItemCondition;
    private final Set<Integer> slots;
    private ItemStack[] savedStacks;

    public KeepInventoryPower(PowerType<?> type, LivingEntity entity, Predicate<ItemStack> keepItemCondition, Collection<Integer> slots) {
        super(type, entity);
        this.keepItemCondition = keepItemCondition;
        this.slots = slots == null ? null : new HashSet<Integer>(slots);
    }

    public void preventItemsFromDropping(Container inventory) {
        this.savedStacks = new ItemStack[inventory.m_6643_()];
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack;
            if (this.slots != null && !this.slots.contains(i) || (stack = inventory.m_8020_(i)).m_41619_() || this.keepItemCondition != null && !this.keepItemCondition.test(stack)) continue;
            this.savedStacks[i] = stack;
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void restoreSavedItems(Container inventory) {
        if (this.savedStacks == null) {
            Apoli.LOGGER.error(KeepInventoryPower.class.getSimpleName() + ": Tried to restore items without having saved any on entity \"" + this.entity.m_7755_().getString() + "\". Power may not have functioned correctly.");
            return;
        }
        if (inventory.m_6643_() != this.savedStacks.length) {
            Apoli.LOGGER.error(KeepInventoryPower.class.getSimpleName() + ": Tried to restore items with differently sized inventory on entity \"" + this.entity.m_7755_().getString() + "\". Items may have been lost.");
        }
        for (int i = 0; i < inventory.m_6643_() && i < this.savedStacks.length; ++i) {
            if (this.savedStacks[i] == null || this.savedStacks[i].m_41619_()) continue;
            inventory.m_6836_(i, this.savedStacks[i]);
        }
        this.savedStacks = null;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("keep_inventory"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("slots", SerializableDataTypes.INTS, null), data -> (type, player) -> new KeepInventoryPower((PowerType<?>)type, (LivingEntity)player, (Predicate)data.get("item_condition"), (Collection)data.get("slots"))).allowCondition();
    }
}

