/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemOnItemPower
extends Power {
    private final Predicate<ItemStack> usingItemCondition;
    private final Predicate<ItemStack> onItemCondition;
    private final int resultFromOnStack;
    private final ItemStack newStack;
    private final Consumer<Tuple<Level, ItemStack>> usingItemAction;
    private final Consumer<Tuple<Level, ItemStack>> onItemAction;
    private final Consumer<Tuple<Level, ItemStack>> resultItemAction;
    private final Consumer<Entity> entityAction;

    public ItemOnItemPower(PowerType<?> type, LivingEntity entity, Predicate<ItemStack> usingItemCondition, Predicate<ItemStack> onItemCondition, ItemStack newStack, Consumer<Tuple<Level, ItemStack>> usingItemAction, Consumer<Tuple<Level, ItemStack>> onItemAction, Consumer<Tuple<Level, ItemStack>> resultItemAction, Consumer<Entity> entityAction, int resultFromOnStack) {
        super(type, entity);
        this.usingItemCondition = usingItemCondition;
        this.onItemCondition = onItemCondition;
        this.newStack = newStack;
        this.usingItemAction = usingItemAction;
        this.onItemAction = onItemAction;
        this.resultItemAction = resultItemAction;
        this.entityAction = entityAction;
        this.resultFromOnStack = resultFromOnStack;
    }

    public boolean doesApply(ItemStack using, ItemStack on) {
        if (this.usingItemCondition != null && !this.usingItemCondition.test(using)) {
            return false;
        }
        return this.onItemCondition == null || this.onItemCondition.test(on);
    }

    public ItemStack execute(ItemStack using, ItemStack on, Slot slot) {
        ItemStack stack;
        if (this.newStack != null) {
            stack = this.newStack.m_41777_();
            if (this.resultItemAction != null) {
                this.resultItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)stack));
            }
        } else {
            stack = this.resultFromOnStack > 0 ? on.m_41620_(this.resultFromOnStack) : on;
            if (this.resultItemAction != null) {
                this.resultItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)stack));
            }
        }
        if (this.usingItemAction != null) {
            this.usingItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)using));
        }
        if (this.onItemAction != null) {
            this.onItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)on));
        }
        if (this.newStack != null || this.resultItemAction != null) {
            Player player = (Player)this.entity;
            if (slot.m_7993_().m_41619_()) {
                slot.m_5852_(stack);
            } else {
                player.m_150109_().m_150079_(stack);
            }
        }
        if (this.entityAction != null) {
            this.entityAction.accept((Entity)this.entity);
        }
        return stack;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("item_on_item"), new SerializableData().add("using_item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("on_item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("result_from_on_stack", SerializableDataTypes.INT, (Object)0).add("result", SerializableDataTypes.ITEM_STACK, null).add("using_item_action", ApoliDataTypes.ITEM_ACTION, null).add("on_item_action", ApoliDataTypes.ITEM_ACTION, null).add("result_item_action", ApoliDataTypes.ITEM_ACTION, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> new ItemOnItemPower((PowerType<?>)type, (LivingEntity)player, (ConditionFactory.Instance)data.get("using_item_condition"), (ConditionFactory.Instance)data.get("on_item_condition"), (ItemStack)data.get("result"), (ActionFactory.Instance)data.get("using_item_action"), (ActionFactory.Instance)data.get("on_item_action"), (ActionFactory.Instance)data.get("result_item_action"), (ActionFactory.Instance)data.get("entity_action"), data.getInt("result_from_on_stack"))).allowCondition();
    }
}

