/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InteractionPower
extends Power {
    private final EnumSet<InteractionHand> hands;
    private final InteractionResult actionResult;
    private final Predicate<ItemStack> itemCondition;
    protected final Consumer<Tuple<Level, ItemStack>> heldItemAction;
    protected final ItemStack itemResult;
    protected final Consumer<Tuple<Level, ItemStack>> resultItemAction;

    public InteractionPower(PowerType<?> type, LivingEntity entity, EnumSet<InteractionHand> hands, InteractionResult actionResult, Predicate<ItemStack> itemCondition, Consumer<Tuple<Level, ItemStack>> heldItemAction, ItemStack itemResult, Consumer<Tuple<Level, ItemStack>> resultItemAction) {
        super(type, entity);
        this.hands = hands;
        this.actionResult = actionResult;
        this.itemCondition = itemCondition;
        this.heldItemAction = heldItemAction;
        this.itemResult = itemResult;
        this.resultItemAction = resultItemAction;
    }

    public boolean shouldExecute(InteractionHand hand, ItemStack heldStack) {
        if (!this.doesApplyToHand(hand)) {
            return false;
        }
        return this.doesApplyToItem(heldStack);
    }

    public boolean doesApplyToHand(InteractionHand hand) {
        return this.hands.contains(hand);
    }

    public boolean doesApplyToItem(ItemStack heldStack) {
        return this.itemCondition == null || this.itemCondition.test(heldStack);
    }

    public InteractionResult getActionResult() {
        return this.actionResult;
    }

    protected void performActorItemStuff(InteractionPower power, Player actor, InteractionHand hand) {
        boolean modified;
        ItemStack heldStack = actor.m_21120_(hand);
        if (power.heldItemAction != null) {
            power.heldItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)actor.m_9236_(), (Object)heldStack));
        }
        ItemStack resultingStack = power.itemResult == null ? heldStack : power.itemResult.m_41777_();
        boolean bl = modified = power.itemResult != null;
        if (power.resultItemAction != null) {
            power.resultItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)actor.m_9236_(), (Object)resultingStack));
            modified = true;
        }
        if (modified) {
            if (heldStack.m_41619_()) {
                actor.m_21008_(hand, resultingStack);
            } else {
                actor.m_150109_().m_150079_(resultingStack);
            }
        }
    }
}

