/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.HudRendered;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CooldownPower
extends Power
implements HudRendered {
    protected long lastUseTime;
    public final int cooldownDuration;
    private final HudRender hudRender;

    public CooldownPower(PowerType<?> type, LivingEntity entity, int cooldownDuration, HudRender hudRender) {
        super(type, entity);
        this.cooldownDuration = cooldownDuration;
        this.hudRender = hudRender;
    }

    public boolean canUse() {
        return this.entity.m_20193_().m_46467_() >= this.lastUseTime + (long)this.cooldownDuration && this.isActive();
    }

    public void use() {
        this.lastUseTime = this.entity.m_20193_().m_46467_();
        PowerHolderComponent.syncPower((Entity)this.entity, this.type);
    }

    public float getProgress() {
        float time = this.entity.m_20193_().m_46467_() - this.lastUseTime;
        return Math.min(1.0f, Math.max(time / (float)this.cooldownDuration, 0.0f));
    }

    public int getRemainingTicks() {
        return (int)Math.max(0L, (long)this.cooldownDuration - (this.entity.m_20193_().m_46467_() - this.lastUseTime));
    }

    public void modify(int changeInTicks) {
        this.lastUseTime += (long)changeInTicks;
        long currentTime = this.entity.m_20193_().m_46467_();
        if (this.lastUseTime > currentTime) {
            this.lastUseTime = currentTime;
        }
    }

    public void setCooldown(int cooldownInTicks) {
        long currentTime = this.entity.m_20193_().m_46467_();
        this.lastUseTime = currentTime - (long)Math.min(cooldownInTicks, this.cooldownDuration);
    }

    @Override
    public Tag toTag() {
        return LongTag.m_128882_((long)this.lastUseTime);
    }

    @Override
    public void fromTag(Tag tag) {
        this.lastUseTime = ((LongTag)tag).m_7046_();
    }

    @Override
    public HudRender getRenderSettings() {
        return this.hudRender;
    }

    @Override
    public float getFill() {
        return this.getProgress();
    }

    @Override
    public boolean shouldRender() {
        return this.entity.m_20193_().m_46467_() - this.lastUseTime <= (long)this.cooldownDuration;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("cooldown"), new SerializableData().add("cooldown", SerializableDataTypes.INT).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER), data -> (type, player) -> new CooldownPower((PowerType<?>)type, (LivingEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"))).allowCondition();
    }
}

