/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public class ConditionedAttributePower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final int tickRate;
    private final boolean updateHealth;

    public ConditionedAttributePower(PowerType<?> type, LivingEntity entity, int tickRate, boolean updateHealth) {
        super(type, entity);
        this.setTicking(true);
        this.tickRate = tickRate;
        this.updateHealth = updateHealth;
    }

    @Override
    public void tick() {
        if (this.entity.f_19797_ % this.tickRate == 0) {
            if (this.isActive()) {
                this.addMods();
            } else {
                this.removeMods();
            }
        }
    }

    @Override
    public void onRemoved() {
        this.removeMods();
    }

    public ConditionedAttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public void addMods() {
        float previousMaxHealth = this.entity.m_21233_();
        float previousHealthPercent = this.entity.m_21223_() / previousMaxHealth;
        this.modifiers.forEach(mod -> {
            AttributeInstance instance;
            if (this.entity.m_21204_().m_22171_(mod.getAttribute()) && (instance = this.entity.m_21051_(mod.getAttribute())) != null && !instance.m_22109_(mod.getModifier())) {
                instance.m_22118_(mod.getModifier());
            }
        });
        float afterMaxHealth = this.entity.m_21233_();
        if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
            this.entity.m_21153_(afterMaxHealth * previousHealthPercent);
        }
    }

    public void removeMods() {
        float previousMaxHealth = this.entity.m_21233_();
        float previousHealthPercent = this.entity.m_21223_() / previousMaxHealth;
        this.modifiers.forEach(mod -> {
            AttributeInstance instance;
            if (this.entity.m_21204_().m_22171_(mod.getAttribute()) && (instance = this.entity.m_21051_(mod.getAttribute())) != null && instance.m_22109_(mod.getModifier())) {
                instance.m_22130_(mod.getModifier());
            }
        });
        float afterMaxHealth = this.entity.m_21233_();
        if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
            this.entity.m_21153_(afterMaxHealth * previousHealthPercent);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("conditioned_attribute"), new SerializableData().add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("tick_rate", SerializableDataTypes.INT, (Object)20).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, player) -> {
            ConditionedAttributePower ap = new ConditionedAttributePower((PowerType<?>)type, (LivingEntity)player, data.getInt("tick_rate"), data.getBoolean("update_health"));
            if (data.isPresent("modifier")) {
                ap.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                List modifierList = (List)data.get("modifiers");
                modifierList.forEach(ap::addModifier);
            }
            return ap;
        }).allowCondition();
    }
}

