/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributePower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final boolean updateHealth;

    public AttributePower(PowerType<?> type, LivingEntity entity, boolean updateHealth) {
        super(type, entity);
        this.updateHealth = updateHealth;
    }

    public AttributePower(PowerType<?> type, LivingEntity entity, boolean updateHealth, Attribute attribute, AttributeModifier modifier) {
        this(type, entity, updateHealth);
        this.addModifier(attribute, modifier);
    }

    public AttributePower addModifier(Attribute attribute, AttributeModifier modifier) {
        AttributedEntityAttributeModifier mod = new AttributedEntityAttributeModifier(attribute, modifier);
        this.modifiers.add(mod);
        return this;
    }

    public AttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    @Override
    public void onAdded() {
        if (!this.entity.m_9236_().f_46443_) {
            float previousMaxHealth = this.entity.m_21233_();
            float previousHealthPercent = this.entity.m_21223_() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                if (this.entity.m_21204_().m_22171_(mod.getAttribute())) {
                    this.entity.m_21051_(mod.getAttribute()).m_22118_(mod.getModifier());
                }
            });
            float afterMaxHealth = this.entity.m_21233_();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                this.entity.m_21153_(afterMaxHealth * previousHealthPercent);
            }
        }
    }

    @Override
    public void onRemoved() {
        if (!this.entity.m_9236_().f_46443_) {
            float previousMaxHealth = this.entity.m_21233_();
            float previousHealthPercent = this.entity.m_21223_() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                if (this.entity.m_21204_().m_22171_(mod.getAttribute())) {
                    this.entity.m_21051_(mod.getAttribute()).m_22130_(mod.getModifier());
                }
            });
            float afterMaxHealth = this.entity.m_21233_();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                this.entity.m_21153_(afterMaxHealth * previousHealthPercent);
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("attribute"), new SerializableData().add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, player) -> {
            AttributePower ap = new AttributePower((PowerType<?>)type, (LivingEntity)player, data.getBoolean("update_health"));
            if (data.isPresent("modifier")) {
                ap.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                List modifierList = (List)data.get("modifiers");
                modifierList.forEach(ap::addModifier);
            }
            return ap;
        });
    }
}

