/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.ClassDataRegistry;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifyTransferPower
extends Power {
    private final Class<?> modifyClass;
    private final Attribute attribute;
    private final double valueMultiplier;

    public AttributeModifyTransferPower(PowerType<?> type, LivingEntity entity, Class<?> modifyClass, Attribute attribute, double valueMultiplier) {
        super(type, entity);
        this.modifyClass = modifyClass;
        this.attribute = attribute;
        this.valueMultiplier = valueMultiplier;
    }

    public boolean doesApply(Class<?> cls) {
        return cls.equals(this.modifyClass);
    }

    public void addModifiers(List<Modifier> modifiers) {
        AttributeMap attrContainer = this.entity.m_21204_();
        if (attrContainer.m_22171_(this.attribute)) {
            AttributeInstance attributeInstance = attrContainer.m_22146_(this.attribute);
            attributeInstance.m_22122_().forEach(mod -> {
                AttributeModifier transferMod = new AttributeModifier(mod.m_22214_(), mod.m_22218_() * this.valueMultiplier, mod.m_22217_());
                modifiers.add(ModifierUtil.fromAttributeModifier(transferMod));
            });
        }
    }

    public void apply(List<AttributeModifier> modifiers) {
        AttributeMap attrContainer = this.entity.m_21204_();
        if (attrContainer.m_22171_(this.attribute)) {
            AttributeInstance attributeInstance = attrContainer.m_22146_(this.attribute);
            attributeInstance.m_22122_().forEach(mod -> {
                AttributeModifier transferMod = new AttributeModifier(mod.m_22214_(), mod.m_22218_() * this.valueMultiplier, mod.m_22217_());
                modifiers.add(transferMod);
            });
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("attribute_modify_transfer"), new SerializableData().add("class", ((ClassDataRegistry)ClassDataRegistry.get(Power.class).get()).getDataType()).add("attribute", SerializableDataTypes.ATTRIBUTE).add("multiplier", SerializableDataTypes.DOUBLE, (Object)1.0), data -> (type, player) -> new AttributeModifyTransferPower((PowerType<?>)type, (LivingEntity)player, (Class)data.get("class"), (Attribute)data.get("attribute"), data.getDouble("multiplier"))).allowCondition();
    }
}

