/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ActiveCooldownPower
extends CooldownPower
implements Active {
    private final Consumer<Entity> activeFunction;
    private Active.Key key;

    public ActiveCooldownPower(PowerType<?> type, LivingEntity entity, int cooldownDuration, HudRender hudRender, Consumer<Entity> activeFunction) {
        super(type, entity, cooldownDuration, hudRender);
        this.activeFunction = activeFunction;
    }

    @Override
    public void onUse() {
        if (this.canUse()) {
            this.activeFunction.accept((Entity)this.entity);
            this.use();
        }
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }

    public static PowerFactory createActiveSelfFactory() {
        return new PowerFactory(Apoli.identifier("active_self"), new SerializableData().add("entity_action", ApoliDataTypes.ENTITY_ACTION).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()), data -> (type, player) -> {
            ActiveCooldownPower power = new ActiveCooldownPower((PowerType<?>)type, (LivingEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (ActionFactory.Instance)data.get("entity_action"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition();
    }

    public static PowerFactory createLaunchFactory() {
        return new PowerFactory(Apoli.identifier("launch"), new SerializableData().add("cooldown", SerializableDataTypes.INT, (Object)1).add("speed", SerializableDataTypes.FLOAT).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()), data -> {
            SoundEvent soundEvent = (SoundEvent)data.get("sound");
            return (type, player) -> {
                ActiveCooldownPower power = new ActiveCooldownPower((PowerType<?>)type, (LivingEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), e -> {
                    if (!e.m_9236_().f_46443_ && e instanceof Player) {
                        Player p = (Player)e;
                        p.m_5997_(0.0, (double)data.getFloat("speed"), 0.0);
                        p.f_19864_ = true;
                        if (soundEvent != null) {
                            p.m_9236_().m_6263_((Player)null, p.m_20185_(), p.m_20186_(), p.m_20189_(), soundEvent, SoundSource.NEUTRAL, 0.5f, 0.4f / (p.m_217043_().m_188501_() * 0.4f + 0.8f));
                        }
                        for (int i = 0; i < 4; ++i) {
                            ((ServerLevel)p.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, p.m_20185_(), p.m_20187_(), p.m_20189_(), 8, p.m_217043_().m_188583_(), 0.0, p.m_217043_().m_188583_(), 0.5);
                        }
                    }
                });
                power.setKey((Active.Key)data.get("key"));
                return power;
            };
        }).allowCondition();
    }
}

