/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ActionWhenHitPower
extends CooldownPower {
    private final Predicate<Tuple<DamageSource, Float>> damageCondition;
    private final Predicate<Tuple<Entity, Entity>> bientityCondition;
    private final Consumer<Tuple<Entity, Entity>> bientityAction;

    public ActionWhenHitPower(PowerType<?> type, LivingEntity entity, int cooldownDuration, HudRender hudRender, Predicate<Tuple<DamageSource, Float>> damageCondition, Consumer<Tuple<Entity, Entity>> bientityAction, Predicate<Tuple<Entity, Entity>> bientityCondition) {
        super(type, entity, cooldownDuration, hudRender);
        this.damageCondition = damageCondition;
        this.bientityAction = bientityAction;
        this.bientityCondition = bientityCondition;
    }

    public void whenHit(Entity attacker, DamageSource damageSource, float damageAmount) {
        if (this.canUse() && (this.bientityCondition == null || this.bientityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)attacker, (Object)this.entity))) && (this.damageCondition == null || this.damageCondition.test((Tuple<DamageSource, Float>)new Tuple((Object)damageSource, (Object)Float.valueOf(damageAmount))))) {
            this.bientityAction.accept((Tuple<Entity, Entity>)new Tuple((Object)attacker, (Object)this.entity));
            this.use();
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("action_when_hit"), new SerializableData().add("bientity_action", ApoliDataTypes.BIENTITY_ACTION).add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null), data -> (type, player) -> new ActionWhenHitPower((PowerType<?>)type, (LivingEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (ConditionFactory.Instance)data.get("damage_condition"), (ActionFactory.Instance)data.get("bientity_action"), (ConditionFactory.Instance)data.get("bientity_condition"))).allowCondition();
    }
}

