/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ActionOverTimePower
extends Power {
    private final int interval;
    private final Consumer<Entity> entityAction;
    private final Consumer<Entity> risingAction;
    private final Consumer<Entity> fallingAction;
    private boolean wasActive = false;
    private Integer initialTicks = null;

    public ActionOverTimePower(PowerType<?> type, LivingEntity entity, int interval, Consumer<Entity> entityAction, Consumer<Entity> risingAction, Consumer<Entity> fallingAction) {
        super(type, entity);
        if (interval <= 0) {
            interval = 1;
        }
        this.interval = interval;
        this.entityAction = entityAction;
        this.risingAction = risingAction;
        this.fallingAction = fallingAction;
        this.setTicking(true);
    }

    @Override
    public void tick() {
        if (this.initialTicks == null) {
            this.initialTicks = this.entity.f_19797_ % this.interval;
        } else if (this.entity.f_19797_ % this.interval == this.initialTicks) {
            if (this.isActive()) {
                if (!this.wasActive && this.risingAction != null) {
                    this.risingAction.accept((Entity)this.entity);
                }
                if (this.entityAction != null) {
                    this.entityAction.accept((Entity)this.entity);
                }
                this.wasActive = true;
            } else {
                if (this.wasActive && this.fallingAction != null) {
                    this.fallingAction.accept((Entity)this.entity);
                }
                this.wasActive = false;
            }
        }
    }

    @Override
    public Tag toTag() {
        return ByteTag.m_128273_((boolean)this.wasActive);
    }

    @Override
    public void fromTag(Tag tag) {
        this.wasActive = tag.equals((Object)ByteTag.f_128257_);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("action_over_time"), new SerializableData().add("interval", SerializableDataTypes.INT, (Object)20).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("rising_action", ApoliDataTypes.ENTITY_ACTION, null).add("falling_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> new ActionOverTimePower((PowerType<?>)type, (LivingEntity)player, data.getInt("interval"), (Consumer)data.get("entity_action"), (Consumer)data.get("rising_action"), (Consumer)data.get("falling_action"))).allowCondition();
    }
}

