/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.networking;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.ActionOnLandPower;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PreventBeingUsedPower;
import io.github.apace100.apoli.power.PreventEntityUsePower;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ModPacketsC2S {
    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.USE_ACTIVE_POWERS, ModPacketsC2S::useActivePowers);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.PLAYER_LANDED, ModPacketsC2S::playerLanded);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.PREVENTED_ENTITY_USE, ModPacketsC2S::interactionPrevented);
    }

    private static void playerLanded(MinecraftServer minecraftServer, ServerPlayer playerEntity, ServerGamePacketListenerImpl serverPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        minecraftServer.execute(() -> PowerHolderComponent.getPowers((Entity)playerEntity, ActionOnLandPower.class).forEach(ActionOnLandPower::executeAction));
    }

    private static void interactionPrevented(MinecraftServer minecraftServer, ServerPlayer playerEntity, ServerGamePacketListenerImpl serverPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int otherEntityId = packetByteBuf.readInt();
        int handOrdinal = packetByteBuf.readInt();
        minecraftServer.execute(() -> {
            Entity otherEntity = playerEntity.m_9236_().m_6815_(otherEntityId);
            InteractionHand hand = InteractionHand.values()[handOrdinal];
            if (otherEntity == null) {
                Apoli.LOGGER.warn("Received unknown entity for prevented interaction");
            } else {
                boolean prevented = false;
                for (PreventEntityUsePower peup : PowerHolderComponent.getPowers((Entity)playerEntity, PreventEntityUsePower.class)) {
                    if (!peup.doesApply(otherEntity, hand, playerEntity.m_21120_(hand))) continue;
                    peup.executeAction(otherEntity, hand);
                    prevented = true;
                    break;
                }
                if (!prevented) {
                    for (PreventBeingUsedPower pbup : PowerHolderComponent.getPowers(otherEntity, PreventBeingUsedPower.class)) {
                        if (!pbup.doesApply((Player)playerEntity, hand, playerEntity.m_21120_(hand))) continue;
                        pbup.executeAction((Player)playerEntity, hand);
                        prevented = true;
                        break;
                    }
                    if (!prevented) {
                        Apoli.LOGGER.warn("Couldn't find corresponding entity use preventing power");
                    }
                }
            }
        });
    }

    private static void useActivePowers(MinecraftServer minecraftServer, ServerPlayer playerEntity, ServerGamePacketListenerImpl serverPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int count = packetByteBuf.readInt();
        ResourceLocation[] powerIds = new ResourceLocation[count];
        for (int i = 0; i < count; ++i) {
            powerIds[i] = packetByteBuf.m_130281_();
        }
        minecraftServer.execute(() -> {
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)playerEntity);
            for (ResourceLocation id : powerIds) {
                PowerType type = PowerTypeRegistry.get(id);
                Object power = component.getPower(type);
                if (!(power instanceof Active)) continue;
                ((Active)power).onUse();
            }
        });
    }

    private static void handleHandshakeReply(MinecraftServer minecraftServer, ServerLoginPacketListenerImpl serverLoginNetworkHandler, boolean understood, FriendlyByteBuf packetByteBuf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        if (understood) {
            int clientSemVerLength = packetByteBuf.readInt();
            int[] clientSemVer = new int[clientSemVerLength];
            boolean mismatch = clientSemVerLength != Apoli.SEMVER.length;
            for (int i = 0; i < clientSemVerLength; ++i) {
                clientSemVer[i] = packetByteBuf.readInt();
                if (i >= clientSemVerLength - 1 || clientSemVer[i] == Apoli.SEMVER[i]) continue;
                mismatch = true;
            }
            if (mismatch) {
                StringBuilder clientVersionString = new StringBuilder();
                for (int i = 0; i < clientSemVerLength; ++i) {
                    clientVersionString.append(clientSemVer[i]);
                    if (i >= clientSemVerLength - 1) continue;
                    clientVersionString.append(".");
                }
                serverLoginNetworkHandler.m_10053_((Component)Component.m_237110_((String)"apoli.gui.version_mismatch", (Object[])new Object[]{Apoli.VERSION, clientVersionString}));
            }
        } else {
            serverLoginNetworkHandler.m_10053_((Component)Component.m_237113_((String)("This server requires you to install the Apoli mod (v" + Apoli.VERSION + ") to play.")));
        }
    }

    private static void handshake(ServerLoginPacketListenerImpl serverLoginNetworkHandler, MinecraftServer minecraftServer, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        packetSender.sendPacket(ModPackets.HANDSHAKE, PacketByteBufs.empty());
    }
}

