/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.apoli.ApoliClient;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.EntityGlowPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.SelfGlowPower;
import io.github.apace100.apoli.util.MiscUtil;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Environment(value=EnvType.CLIENT)
@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Final
    @Shadow
    private Minecraft f_109461_;
    @Unique
    private Entity renderEntity;

    @Shadow
    public abstract void m_109818_();

    @Shadow
    public abstract void m_109599_(PoseStack var1, float var2, long var3, boolean var5, Camera var6, GameRenderer var7, LightTexture var8, Matrix4f var9);

    @Inject(method={"renderSky(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Runnable;run()V", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    private void skipSkyRenderingForPhasingBlindness(PoseStack matrices, Matrix4f projectionMatrix, float tickDelta, Camera camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        List<PhasingPower> phasings;
        if (camera.m_90592_() instanceof LivingEntity && (phasings = PowerHolderComponent.getPowers(camera.m_90592_(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && MiscUtil.getInWallBlockState((LivingEntity)camera.m_90592_()) != null) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void updateChunksIfRenderChanged(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (ApoliClient.shouldReloadWorldRenderer) {
            this.m_109818_();
            ApoliClient.shouldReloadWorldRenderer = false;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/Entity;getTeamColorValue()I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getEntity(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci, ProfilerFiller profiler, Vec3 vec3d, double d, double e, double f, Matrix4f matrix4f, boolean bl, Frustum frustum, float g, boolean bl2, boolean bl3, MultiBufferSource.BufferSource immediate, Iterator var25, Entity entity) {
        this.renderEntity = entity;
    }

    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/OutlineVertexConsumerProvider;setColor(IIII)V"))
    private void setColors(Args args) {
        for (EntityGlowPower entityGlowPower : PowerHolderComponent.getPowers(this.f_109461_.m_91288_(), EntityGlowPower.class)) {
            if (!entityGlowPower.doesApply(this.renderEntity) || entityGlowPower.usesTeams()) continue;
            args.set(0, (Object)((int)(entityGlowPower.getRed() * 255.0f)));
            args.set(1, (Object)((int)(entityGlowPower.getGreen() * 255.0f)));
            args.set(2, (Object)((int)(entityGlowPower.getBlue() * 255.0f)));
        }
        for (SelfGlowPower selfGlowPower : PowerHolderComponent.getPowers(this.renderEntity, SelfGlowPower.class)) {
            if (selfGlowPower.usesTeams()) continue;
            args.set(0, (Object)((int)(selfGlowPower.getRed() * 255.0f)));
            args.set(1, (Object)((int)(selfGlowPower.getGreen() * 255.0f)));
            args.set(2, (Object)((int)(selfGlowPower.getBlue() * 255.0f)));
        }
    }
}

