/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnBlockBreakPower;
import io.github.apace100.apoli.power.ActionOnBlockUsePower;
import io.github.apace100.apoli.power.ModifyHarvestPower;
import io.github.apace100.apoli.power.PreventBlockUsePower;
import io.github.apace100.apoli.util.SavedBlockPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    public ServerLevel f_9244_;
    @Shadow
    public ServerPlayer f_9245_;
    private SavedBlockPosition savedBlockPosition;

    @Inject(method={"tryBreakBlock"}, at={@At(value="HEAD")})
    private void cacheBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        this.savedBlockPosition = new SavedBlockPosition((LevelReader)this.f_9244_, pos);
    }

    @ModifyVariable(method={"tryBreakBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;postMine(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;)V"), ordinal=1)
    private boolean modifyEffectiveTool(boolean original) {
        for (ModifyHarvestPower mhp : PowerHolderComponent.getPowers((Entity)this.f_9245_, ModifyHarvestPower.class)) {
            if (!mhp.doesApply(this.savedBlockPosition)) continue;
            return mhp.isHarvestAllowed();
        }
        return original;
    }

    @Inject(method={"tryBreakBlock"}, at={@At(value="RETURN", ordinal=4, shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void actionOnBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> cir, BlockState blockState, BlockEntity blockEntity, Block block, boolean bl, ItemStack itemStack, ItemStack itemStack2, boolean bl2) {
        PowerHolderComponent.getPowers((Entity)this.f_9245_, ActionOnBlockBreakPower.class).stream().filter(p -> p.doesApply(this.savedBlockPosition)).forEach(aobbp -> aobbp.executeActions(bl && bl2, pos, null));
    }

    @Inject(method={"interactBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;shouldCancelInteraction()Z")}, cancellable=true)
    private void preventBlockInteraction(ServerPlayer player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (PowerHolderComponent.getPowers((Entity)player, PreventBlockUsePower.class).stream().anyMatch(p -> p.doesPrevent((LevelReader)world, hitResult.m_82425_()))) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Inject(method={"interactBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;copy()Lnet/minecraft/item/ItemStack;")}, cancellable=true)
    private void executeBlockUseActions(ServerPlayer player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        PowerHolderComponent.getPowers((Entity)player, ActionOnBlockUsePower.class).stream().filter(p -> p.shouldExecute(hitResult.m_82425_(), hitResult.m_82434_(), hand, stack)).forEach(p -> p.executeAction(hitResult.m_82425_(), hitResult.m_82434_(), hand));
    }
}

