/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.IdentifiedLootTable;
import io.github.apace100.apoli.access.ReplacingLootContext;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ReplaceLootTablePower;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootTable.class})
public class LootTableMixin
implements IdentifiedLootTable {
    @Unique
    private ResourceLocation apoli$id;
    @Unique
    private LootDataManager apoli$lootManager;

    @Override
    public void setId(ResourceLocation id, LootDataManager lootManager) {
        this.apoli$id = id;
        this.apoli$lootManager = lootManager;
    }

    @Override
    public ResourceLocation getId() {
        return this.apoli$id;
    }

    @Inject(method={"generateUnprocessedLoot(Lnet/minecraft/loot/context/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyLootTable(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        if (((ReplacingLootContext)context).isReplaced((LootTable)this)) {
            return;
        }
        if (context.m_78936_(LootContextParams.f_81455_)) {
            Piglin piglin;
            Optional optional;
            LootContextParamSet type = ((ReplacingLootContext)context).getType();
            Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
            if (type == LootContextParamSets.f_81414_) {
                if (entity instanceof FishingHook) {
                    FishingHook bobber = (FishingHook)entity;
                    entity = bobber.m_37168_();
                }
            } else if (type == LootContextParamSets.f_81415_) {
                if (context.m_78936_(LootContextParams.f_81458_)) {
                    entity = (Entity)context.m_78953_(LootContextParams.f_81458_);
                }
            } else if (type == LootContextParamSets.f_81417_ && entity instanceof Piglin && (optional = (piglin = (Piglin)entity).m_6274_().m_257414_(MemoryModuleType.f_26368_)).isPresent()) {
                entity = (Entity)optional.get();
            }
            List<ReplaceLootTablePower> powers = PowerHolderComponent.getPowers(entity, ReplaceLootTablePower.class);
            powers = powers.stream().filter(p -> p.hasReplacement(this.apoli$id) && p.doesApply(context)).sorted(Comparator.comparing(ReplaceLootTablePower::getPriority)).toList();
            if (powers.size() == 0) {
                return;
            }
            ReplaceLootTablePower.addToStack((LootTable)this);
            LootTable replacement = null;
            for (ReplaceLootTablePower power : powers) {
                ResourceLocation id = power.getReplacement(this.apoli$id);
                replacement = this.apoli$lootManager.m_278676_(id);
                ReplaceLootTablePower.addToStack(replacement);
            }
            ((ReplacingLootContext)context).setReplaced((LootTable)this);
            replacement.m_79131_(context, lootConsumer);
            ReplaceLootTablePower.clearStack();
            ci.cancel();
        }
    }

    @Inject(method={"generateUnprocessedLoot(Lnet/minecraft/loot/context/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/loot/context/LootContext;markActive(Lnet/minecraft/loot/context/LootContext$Entry;)Z")})
    private void popReplacementStack(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        ReplaceLootTablePower.pop();
    }

    @Inject(method={"generateUnprocessedLoot(Lnet/minecraft/loot/context/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/loot/context/LootContext;markInactive(Lnet/minecraft/loot/context/LootContext$Entry;)V")})
    private void restoreReplacementStack(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        ReplaceLootTablePower.restore();
    }
}

