/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.HiddenEffectStatus;
import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.ActionOnHitPower;
import io.github.apace100.apoli.power.ActionWhenHitPower;
import io.github.apace100.apoli.power.AttackerActionWhenHitPower;
import io.github.apace100.apoli.power.ClimbingPower;
import io.github.apace100.apoli.power.EffectImmunityPower;
import io.github.apace100.apoli.power.FreezePower;
import io.github.apace100.apoli.power.ModifyAirSpeedPower;
import io.github.apace100.apoli.power.ModifyAttributePower;
import io.github.apace100.apoli.power.ModifyDamageDealtPower;
import io.github.apace100.apoli.power.ModifyDamageTakenPower;
import io.github.apace100.apoli.power.ModifyFallingPower;
import io.github.apace100.apoli.power.ModifyFoodPower;
import io.github.apace100.apoli.power.ModifyHealingPower;
import io.github.apace100.apoli.power.ModifyJumpPower;
import io.github.apace100.apoli.power.ModifyProjectileDamagePower;
import io.github.apace100.apoli.power.ModifySlipperinessPower;
import io.github.apace100.apoli.power.ModifyStatusEffectAmplifierPower;
import io.github.apace100.apoli.power.ModifyStatusEffectDurationPower;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PreventDeathPower;
import io.github.apace100.apoli.power.PreventEntityCollisionPower;
import io.github.apace100.apoli.power.SelfActionOnHitPower;
import io.github.apace100.apoli.power.SelfActionOnKillPower;
import io.github.apace100.apoli.power.SelfActionWhenHitPower;
import io.github.apace100.apoli.power.SetEntityGroupPower;
import io.github.apace100.apoli.power.SwimmingPower;
import io.github.apace100.apoli.power.TargetActionOnHitPower;
import io.github.apace100.apoli.power.WalkOnFluidPower;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.apace100.apoli.util.SyncStatusEffectsUtil;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ModifiableFoodEntity {
    @Shadow
    private Optional<BlockPos> f_20957_;
    @Unique
    private boolean apoli$hasModifiedDamage;
    @Unique
    private Optional<Boolean> apoli$shouldApplyArmor = Optional.empty();
    @Unique
    private Optional<Boolean> apoli$shouldDamageArmor = Optional.empty();
    @Unique
    private boolean prevPowderSnowState = false;
    @Unique
    private float cachedDamageAmount;
    @Shadow
    @Nullable
    private LivingEntity f_20949_;
    @Unique
    private List<ModifyFoodPower> apoli$currentModifyFoodPowers = new LinkedList<ModifyFoodPower>();
    @Unique
    private ItemStack apoli$originalFoodStack;

    @Shadow
    protected abstract float m_6118_();

    @Shadow
    public abstract float m_6113_();

    @Shadow
    public abstract boolean m_5791_();

    @Shadow
    public abstract void m_21153_(float var1);

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="TAIL")})
    private void updateStatusEffectWhenApplied(MobEffectInstance effectInstance, Entity source, CallbackInfo ci) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((LivingEntity)this, SyncStatusEffectsUtil.UpdateType.APPLY, effectInstance);
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="TAIL")})
    private void updateStatusEffectWhenUpgraded(MobEffectInstance effectInstance, boolean reapplyEffect, Entity source, CallbackInfo ci) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((LivingEntity)this, SyncStatusEffectsUtil.UpdateType.UPGRADE, effectInstance);
    }

    @Inject(method={"onStatusEffectRemoved"}, at={@At(value="TAIL")})
    private void updateStatusEffectWhenRemoved(MobEffectInstance effectInstance, CallbackInfo ci) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((LivingEntity)this, SyncStatusEffectsUtil.UpdateType.REMOVE, effectInstance);
    }

    @Inject(method={"clearStatusEffects"}, at={@At(value="RETURN")})
    private void updateStatusEffectWhenCleared(CallbackInfoReturnable<Boolean> cir) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((LivingEntity)this, SyncStatusEffectsUtil.UpdateType.CLEAR, null);
    }

    @ModifyVariable(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at=@At(value="HEAD"), ordinal=0)
    private MobEffectInstance modifyStatusEffect(MobEffectInstance effect) {
        MobEffect effectType = effect.m_19544_();
        int originalAmp = effect.m_19564_();
        int originalDur = effect.m_19557_();
        int amplifier = Math.round(PowerHolderComponent.modify(this, ModifyStatusEffectAmplifierPower.class, originalAmp, power -> power.doesApply(effectType)));
        int duration = Math.round(PowerHolderComponent.modify(this, ModifyStatusEffectDurationPower.class, originalDur, power -> power.doesApply(effectType)));
        if (amplifier != originalAmp || duration != originalDur) {
            return new MobEffectInstance(effectType, duration, amplifier, effect.m_19571_(), effect.m_19572_(), effect.m_19575_(), ((HiddenEffectStatus)effect).getHiddenEffect(), Optional.empty());
        }
        return effect;
    }

    @Inject(method={"setAttacker"}, at={@At(value="TAIL")})
    private void syncAttacker(LivingEntity attacker, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(this.m_19879_());
            if (this.f_20949_ == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(this.f_20949_.m_19879_());
            }
            for (ServerPlayer player : PlayerLookup.tracking((Entity)this)) {
                ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.SET_ATTACKER, (FriendlyByteBuf)buf);
            }
        }
    }

    @Inject(method={"getEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/AttributeContainer;removeModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void removeEquipmentPowers(CallbackInfoReturnable<Map> cir, Map map, EquipmentSlot[] var2, int var3, int var4, EquipmentSlot equipmentSlot, ItemStack itemStack3, ItemStack itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack3, equipmentSlot);
        if (powers.size() > 0) {
            ResourceLocation source = new ResourceLocation("apoli", equipmentSlot.m_20751_());
            PowerHolderComponent powerHolder = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this);
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    powerHolder.removePower(PowerTypeRegistry.get(sp.powerId), source);
                }
            });
            powerHolder.sync();
        }
    }

    @Inject(method={"getEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/AttributeContainer;addTemporaryModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addEquipmentPowers(CallbackInfoReturnable<Map> cir, Map map, EquipmentSlot[] var2, int var3, int var4, EquipmentSlot equipmentSlot, ItemStack itemStack3, ItemStack itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack4, equipmentSlot);
        if (powers.size() > 0) {
            ResourceLocation source = new ResourceLocation("apoli", equipmentSlot.m_20751_());
            PowerHolderComponent powerHolder = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this);
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    powerHolder.addPower(PowerTypeRegistry.get(sp.powerId), source);
                }
            });
            powerHolder.sync();
        } else if (StackPowerUtil.getPowers(itemStack3, equipmentSlot).size() > 0) {
            ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this)).sync();
        }
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyWalkableFluids(FluidState fluidState, CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.getPowers(this, WalkOnFluidPower.class).stream().anyMatch(p -> fluidState.m_205070_(p.getFluidTag()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyHealingApplied(float originalValue) {
        return PowerHolderComponent.modify((Entity)this, ModifyHealingPower.class, originalValue);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyDamageTaken(float originalValue, DamageSource source, float amount) {
        long dontWantArmor;
        float intermediateValue;
        float newValue = originalValue;
        LivingEntity thisAsLiving = (LivingEntity)this;
        if (source.m_7639_() != null) {
            newValue = !source.m_269533_(DamageTypeTags.f_268524_) ? PowerHolderComponent.modify(source.m_7639_(), ModifyDamageDealtPower.class, originalValue, p -> p.doesApply(source, originalValue, thisAsLiving), p -> p.executeActions((Entity)thisAsLiving)) : PowerHolderComponent.modify(source.m_7639_(), ModifyProjectileDamagePower.class, originalValue, p -> p.doesApply(source, originalValue, thisAsLiving), p -> p.executeActions((Entity)thisAsLiving));
        }
        this.apoli$hasModifiedDamage = (newValue = PowerHolderComponent.modify((Entity)this, ModifyDamageTakenPower.class, intermediateValue = newValue, p -> p.doesApply(source, intermediateValue), p -> p.executeActions(source.m_7639_()))) != originalValue;
        List<ModifyDamageTakenPower> mdtps = PowerHolderComponent.getPowers(this, ModifyDamageTakenPower.class).stream().filter(p -> p.doesApply(source, originalValue)).toList();
        long wantArmor = mdtps.stream().filter(p -> p.modifiesArmorApplicance() && p.shouldApplyArmor()).count();
        this.apoli$shouldApplyArmor = wantArmor == (dontWantArmor = mdtps.stream().filter(p -> p.modifiesArmorApplicance() && !p.shouldApplyArmor()).count()) ? Optional.empty() : Optional.of(wantArmor > dontWantArmor);
        long wantDamage = mdtps.stream().filter(p -> p.modifiesArmorDamaging() && p.shouldDamageArmor()).count();
        long dontWantDamage = mdtps.stream().filter(p -> p.modifiesArmorDamaging() && !p.shouldDamageArmor()).count();
        this.apoli$shouldDamageArmor = wantDamage == dontWantDamage ? Optional.empty() : Optional.of(wantDamage > dontWantDamage);
        return newValue;
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyArmorApplicance(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        if (this.apoli$shouldApplyArmor.isPresent()) {
            if (this.apoli$shouldDamageArmor.isPresent() && this.apoli$shouldDamageArmor.get().booleanValue()) {
                this.m_6472_(source, amount);
            }
            if (this.apoli$shouldApplyArmor.get().booleanValue()) {
                if (this.apoli$shouldDamageArmor.isEmpty()) {
                    this.m_6472_(source, amount);
                }
                float damageLeft = CombatRules.m_19272_((float)amount, (float)this.m_21230_(), (float)((float)this.m_21133_(Attributes.f_22285_)));
                cir.setReturnValue((Object)Float.valueOf(damageLeft));
            } else {
                cir.setReturnValue((Object)Float.valueOf(amount));
            }
        } else if (this.apoli$shouldDamageArmor.isPresent() && this.apoli$shouldDamageArmor.get().booleanValue() && source.m_269533_(DamageTypeTags.f_268490_)) {
            this.m_6472_(source, amount);
        }
    }

    @Redirect(method={"applyArmorToDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageArmor(Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void preventArmorDamaging(LivingEntity instance, DamageSource source, float amount) {
        if (this.apoli$shouldDamageArmor.isPresent() && !this.apoli$shouldDamageArmor.get().booleanValue()) {
            return;
        }
        this.m_6472_(source, amount);
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isSleeping()Z")}, cancellable=true)
    private void preventHitIfDamageIsZero(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.apoli$hasModifiedDamage && amount <= 0.0f) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void invokeHitActions(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            Entity attacker = source.m_7639_();
            if (attacker != null) {
                PowerHolderComponent.withPowers(this, ActionWhenHitPower.class, p -> true, p -> p.whenHit(attacker, source, amount));
                PowerHolderComponent.withPowers(attacker, ActionOnHitPower.class, p -> true, p -> p.onHit(this, source, amount));
            }
            PowerHolderComponent.getPowers(this, SelfActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            PowerHolderComponent.getPowers(this, AttackerActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            PowerHolderComponent.getPowers(source.m_7639_(), SelfActionOnHitPower.class).forEach(p -> p.onHit((Entity)((LivingEntity)this), source, amount));
            PowerHolderComponent.getPowers(source.m_7639_(), TargetActionOnHitPower.class).forEach(p -> p.onHit((LivingEntity)this, source, amount));
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeath(Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void invokeKillAction(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        PowerHolderComponent.getPowers(source.m_7639_(), SelfActionOnKillPower.class).forEach(p -> p.onKill((Entity)((LivingEntity)this), source, amount));
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(LivingEntity livingEntity) {
        if (PowerHolderComponent.hasPower((Entity)livingEntity, SwimmingPower.class) && livingEntity.m_6069_() && !(this.m_204036_(FluidTags.f_13131_) > 0.0)) {
            return false;
        }
        return livingEntity.m_20071_();
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getFrozenTicks()I")})
    private void freezeEntityFromPower(CallbackInfo ci) {
        if (PowerHolderComponent.hasPower(this, FreezePower.class)) {
            this.prevPowderSnowState = this.f_146808_;
            this.f_146808_ = true;
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;removePowderSnowSlow()V")})
    private void unfreezeEntityFromPower(CallbackInfo ci) {
        if (PowerHolderComponent.hasPower(this, FreezePower.class)) {
            this.f_146808_ = this.prevPowderSnowState;
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN")}, cancellable=true)
    private void allowFreezingPower(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower(this, FreezePower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getGroup"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<MobType> info) {
        PowerHolderComponent component;
        List<SetEntityGroupPower> groups;
        if (this instanceof LivingEntity && (groups = (component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this)).getPowers(SetEntityGroupPower.class)).size() > 0) {
            if (groups.size() > 1) {
                Apoli.LOGGER.warn("Entity " + this.m_5446_().toString() + " has two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)groups.get((int)0).group);
        }
    }

    @Redirect(method={"jump"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getJumpVelocity()F"))
    private float modifyJumpVelocity(LivingEntity entity) {
        return PowerHolderComponent.modify(this, ModifyJumpPower.class, this.m_6118_(), p -> {
            p.executeAction();
            return true;
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"canHaveStatusEffect"}, cancellable=true)
    private void preventStatusEffects(MobEffectInstance effect, CallbackInfoReturnable<Boolean> info) {
        for (EffectImmunityPower power : PowerHolderComponent.getPowers(this, EffectImmunityPower.class)) {
            if (!power.doesApply(effect)) continue;
            info.setReturnValue((Object)false);
            return;
        }
    }

    @ModifyReturnValue(method={"isClimbing"}, at={@At(value="RETURN")})
    private boolean apoli$modifyClimbing(boolean original) {
        if (original) {
            return true;
        }
        List<ClimbingPower> climbingPowers = PowerHolderComponent.getPowers(this, ClimbingPower.class);
        if (this.m_5833_() || climbingPowers.isEmpty()) {
            return false;
        }
        this.f_20957_ = Optional.of(this.m_20183_());
        return true;
    }

    @ModifyReturnValue(method={"isHoldingOntoLadder"}, at={@At(value="RETURN")})
    private boolean apoli$overrideClimbHold(boolean original) {
        List<ClimbingPower> climbingPowers = PowerHolderComponent.getPowers(this, ClimbingPower.class);
        if (climbingPowers.isEmpty()) {
            return original;
        }
        return climbingPowers.stream().anyMatch(ClimbingPower::canHold);
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"), method={"travel"}, name={"d"}, ordinal=0)
    public double modifyFallingVelocity(double in) {
        if (this.m_20184_().f_82480_ > 0.0) {
            return in;
        }
        List<ModifyFallingPower> modifyFallingPowers = PowerHolderComponent.getPowers(this, ModifyFallingPower.class);
        if (modifyFallingPowers.size() > 0) {
            if (modifyFallingPowers.stream().anyMatch(p -> !p.takeFallDamage)) {
                this.f_19789_ = 0.0f;
            }
            return PowerHolderComponent.modify((Entity)this, ModifyFallingPower.class, in);
        }
        return in;
    }

    @Inject(method={"getAttributeValue(Lnet/minecraft/entity/attribute/EntityAttribute;)D"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyAttributeValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        double modified;
        double originalValue = this.m_21204_().m_22181_(attribute);
        if (originalValue != (modified = (double)PowerHolderComponent.modify(this, ModifyAttributePower.class, (float)originalValue, p -> p.getAttribute() == attribute))) {
            cir.setReturnValue((Object)modified);
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isOnGround()Z", opcode=180, ordinal=2), ordinal=0)
    private float modifySlipperiness(float original) {
        return PowerHolderComponent.modify(this, ModifySlipperinessPower.class, original, p -> p.doesApply((LevelReader)this.m_9236_(), this.m_20099_()));
    }

    @Inject(method={"pushAway"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPushing(Entity entity, CallbackInfo ci) {
        if (PowerHolderComponent.hasPower(this, PreventEntityCollisionPower.class, p -> p.doesApply(entity)) || PowerHolderComponent.hasPower(entity, PreventEntityCollisionPower.class, p -> p.doesApply(this))) {
            ci.cancel();
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z")})
    private void cacheDamageAmount(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.cachedDamageAmount = amount;
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Hand;values()[Lnet/minecraft/util/Hand;")}, cancellable=true)
    private void preventDeath(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Optional<PreventDeathPower> preventDeathPower = PowerHolderComponent.getPowers(this, PreventDeathPower.class).stream().filter(p -> p.doesApply(source, this.cachedDamageAmount)).findFirst();
        if (preventDeathPower.isPresent()) {
            this.m_21153_(1.0f);
            preventDeathPower.get().executeAction();
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"eatFood"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private ItemStack modifyEatenItemStack(ItemStack original) {
        if (this instanceof Player) {
            return original;
        }
        List<ModifyFoodPower> mfps = PowerHolderComponent.getPowers(this, ModifyFoodPower.class);
        mfps = mfps.stream().filter(mfp -> mfp.doesApply(original)).collect(Collectors.toList());
        ItemStack newStack = original;
        for (ModifyFoodPower mfp2 : mfps) {
            newStack = mfp2.getConsumedItemStack(newStack);
        }
        this.setCurrentModifyFoodPowers(mfps);
        this.setOriginalFoodStack(original);
        return newStack;
    }

    @ModifyVariable(method={"eatFood"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyFoodEffects(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V", shift=At.Shift.AFTER), ordinal=0)
    private ItemStack unmodifyEatenItemStack(ItemStack modified) {
        LivingEntityMixin foodEntity = this;
        ItemStack original = foodEntity.getOriginalFoodStack();
        if (original != null) {
            foodEntity.setOriginalFoodStack(null);
            return original;
        }
        return modified;
    }

    @Inject(method={"eatFood"}, at={@At(value="TAIL")})
    private void removeCurrentModifyFoodPowers(Level world, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        this.setCurrentModifyFoodPowers(new LinkedList<ModifyFoodPower>());
    }

    @Redirect(method={"eatFood"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyFoodEffects(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V"))
    private void preventApplyingFoodEffects(LivingEntity livingEntity, ItemStack stack, Level world, LivingEntity targetEntity) {
        if (this.getCurrentModifyFoodPowers().stream().anyMatch(ModifyFoodPower::doesPreventEffects)) {
            return;
        }
        this.m_21063_(stack, world, targetEntity);
    }

    @Shadow
    protected abstract void m_21063_(ItemStack var1, Level var2, LivingEntity var3);

    @Shadow
    protected abstract void m_6472_(DamageSource var1, float var2);

    @Shadow
    public abstract int m_21230_();

    @Shadow
    public abstract double m_21133_(Attribute var1);

    @Shadow
    public abstract AttributeMap m_21204_();

    @Inject(method={"getOffGroundSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(PowerHolderComponent.modify((Entity)this, ModifyAirSpeedPower.class, ((Float)cir.getReturnValue()).floatValue())));
    }

    @Override
    public List<ModifyFoodPower> getCurrentModifyFoodPowers() {
        return this.apoli$currentModifyFoodPowers;
    }

    @Override
    public void setCurrentModifyFoodPowers(List<ModifyFoodPower> powers) {
        this.apoli$currentModifyFoodPowers = powers;
    }

    @Override
    public ItemStack getOriginalFoodStack() {
        return this.apoli$originalFoodStack;
    }

    @Override
    public void setOriginalFoodStack(ItemStack original) {
        this.apoli$originalFoodStack = original;
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void updateItemStackHolder(CallbackInfo ci) {
        InventoryUtil.forEachStack(this, stack -> stack.m_41636_((Entity)this));
    }
}

