/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ItemOnItemPower;
import io.github.apace100.apoli.power.ModifyFoodPower;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/TypedActionResult;fail(Ljava/lang/Object;)Lnet/minecraft/util/TypedActionResult;")}, cancellable=true)
    private void tryItemAlwaysEdible(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack itemStack = user.m_21120_(hand);
        if (((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)user)).getPowers(ModifyFoodPower.class).stream().anyMatch(p -> p.doesMakeAlwaysEdible() && p.doesApply(itemStack))) {
            user.m_6672_(hand);
            cir.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)itemStack));
        }
    }

    @Inject(method={"onClicked"}, at={@At(value="RETURN")}, cancellable=true)
    private void forgeItem(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (clickType != ClickAction.SECONDARY) {
            return;
        }
        List powers = PowerHolderComponent.getPowers((Entity)player, ItemOnItemPower.class).stream().filter(p -> p.doesApply(otherStack, stack)).collect(Collectors.toList());
        for (ItemOnItemPower p2 : powers) {
            p2.execute(otherStack, stack, slot);
        }
        if (powers.size() > 0) {
            cir.setReturnValue((Object)true);
        }
    }
}

