/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.PowerModifiedGrindstone;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyGrindstonePower;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GrindstoneMenu.class})
public abstract class GrindstoneScreenHandlerMixin
extends AbstractContainerMenu
implements PowerModifiedGrindstone {
    @Shadow
    @Final
    private Container f_39560_;
    @Shadow
    @Final
    private Container f_39559_;
    @Unique
    private Player apoli$cachedPlayer;
    @Unique
    private Optional<BlockPos> apoli$cachedPosition;
    @Unique
    private List<ModifyGrindstonePower> apoli$appliedPowers;

    protected GrindstoneScreenHandlerMixin(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    @Inject(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at={@At(value="RETURN")})
    private void cachePlayer(int syncId, Inventory playerInventory, ContainerLevelAccess context, CallbackInfo ci) {
        this.apoli$cachedPlayer = playerInventory.f_35978_;
        this.apoli$cachedPosition = context.m_6721_((w, bp) -> bp);
    }

    @Inject(method={"updateResult"}, at={@At(value="RETURN")})
    private void modifyResult(CallbackInfo ci) {
        ItemStack top = this.f_39560_.m_8020_(0);
        ItemStack bottom = this.f_39560_.m_8020_(1);
        ItemStack output = this.f_39559_.m_8020_(0);
        List<ModifyGrindstonePower> applyingPowers = PowerHolderComponent.getPowers((Entity)this.apoli$cachedPlayer, ModifyGrindstonePower.class);
        applyingPowers = applyingPowers.stream().filter(mgp -> mgp.doesApply(top, bottom, output, this.apoli$cachedPosition)).toList();
        ItemStack newOutput = output;
        for (ModifyGrindstonePower mgp2 : applyingPowers) {
            newOutput = mgp2.getOutput(top, bottom, newOutput);
        }
        this.apoli$appliedPowers = applyingPowers;
        this.f_39559_.m_6836_(0, newOutput);
        this.m_38946_();
    }

    @Override
    public List<ModifyGrindstonePower> getAppliedPowers() {
        return this.apoli$appliedPowers;
    }

    @Override
    public Player getPlayer() {
        return this.apoli$cachedPlayer;
    }

    @Override
    public Optional<BlockPos> getPos() {
        return this.apoli$cachedPosition;
    }
}

