/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyCameraSubmersionTypePower;
import io.github.apace100.apoli.power.NightVisionPower;
import io.github.apace100.apoli.power.OverlayPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.ShaderPower;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Camera f_109054_;
    @Shadow
    @Final
    private Minecraft f_109059_;
    @Shadow
    private PostChain f_109050_;
    @Shadow
    private boolean f_109053_;
    @Shadow
    @Final
    private ResourceManager f_109060_;
    @Unique
    private ResourceLocation currentlyLoadedShader;
    private HashMap<BlockPos, BlockState> savedStates = new HashMap();

    @Shadow
    protected abstract void m_109128_(ResourceLocation var1);

    @Inject(at={@At(value="TAIL")}, method={"onCameraEntitySet"})
    private void loadShaderFromPowerOnCameraEntity(Entity entity, CallbackInfo ci) {
        PowerHolderComponent.withPower(this.f_109059_.m_91288_(), ShaderPower.class, null, shaderPower -> {
            ResourceLocation shaderLoc = shaderPower.getShaderLocation();
            if (this.f_109060_.m_213713_(shaderLoc).isPresent()) {
                this.m_109128_(shaderLoc);
                this.currentlyLoadedShader = shaderLoc;
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void loadShaderFromPower(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        PowerHolderComponent.withPower(this.f_109059_.m_91288_(), ShaderPower.class, null, shaderPower -> {
            ResourceLocation shaderLoc = shaderPower.getShaderLocation();
            if (this.currentlyLoadedShader != shaderLoc && this.f_109060_.m_213713_(shaderLoc).isPresent()) {
                this.m_109128_(shaderLoc);
                this.currentlyLoadedShader = shaderLoc;
            }
        });
        if (!PowerHolderComponent.hasPower(this.f_109059_.m_91288_(), ShaderPower.class) && this.currentlyLoadedShader != null) {
            if (this.f_109050_ != null) {
                this.f_109050_.close();
                this.f_109050_ = null;
            }
            this.f_109053_ = false;
            this.currentlyLoadedShader = null;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    private void renderOverlayPowers(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        boolean hudHidden = this.f_109059_.f_91066_.f_92062_;
        boolean thirdPerson = !this.f_109059_.f_91066_.m_92176_().m_90612_();
        PowerHolderComponent.withPower(this.f_109059_.m_91288_(), OverlayPower.class, p -> {
            if (p.getDrawPhase() != OverlayPower.DrawPhase.ABOVE_HUD) {
                return false;
            }
            if (hudHidden && p.doesHideWithHud()) {
                return false;
            }
            return !thirdPerson || p.shouldBeVisibleInThirdPerson();
        }, OverlayPower::render);
    }

    @Inject(at={@At(value="HEAD")}, method={"togglePostProcessorEnabled"}, cancellable=true)
    private void disableShaderToggle(CallbackInfo ci) {
        PowerHolderComponent.withPower(this.f_109059_.m_91288_(), ShaderPower.class, null, shaderPower -> {
            ResourceLocation shaderLoc = shaderPower.getShaderLocation();
            if (!shaderPower.isToggleable() && this.currentlyLoadedShader == shaderLoc) {
                ci.cancel();
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getNightVisionStrength"}, cancellable=true)
    private static void getNightVisionStrength(LivingEntity livingEntity, float f, CallbackInfoReturnable<Float> info) {
        if (livingEntity instanceof Player && !livingEntity.m_21023_(MobEffects.f_19611_)) {
            List<NightVisionPower> nvs = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingEntity)).getPowers(NightVisionPower.class);
            Optional<Float> strength = nvs.stream().filter(Power::isActive).map(NightVisionPower::getStrength).max(Float::compareTo);
            strength.ifPresent(arg_0 -> info.setReturnValue(arg_0));
        }
    }

    @Redirect(method={"getFov"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;getSubmersionType()Lnet/minecraft/client/render/CameraSubmersionType;"))
    private FogType modifySubmersionType(Camera camera) {
        FogType original = camera.m_167685_();
        if (camera.m_90592_() instanceof LivingEntity) {
            for (ModifyCameraSubmersionTypePower p : PowerHolderComponent.getPowers(camera.m_90592_(), ModifyCameraSubmersionTypePower.class)) {
                if (!p.doesModify(original)) continue;
                return p.getNewType();
            }
        }
        return original;
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void beforeRender(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        block5: {
            block4: {
                List<PhasingPower> phasings = PowerHolderComponent.getPowers(this.f_109054_.m_90592_(), PhasingPower.class);
                if (!phasings.stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS)) break block4;
                float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS).map(PhasingPower::getViewDistance).min(Float::compareTo).get().floatValue();
                Set<BlockPos> eyePositions = this.getEyePos(0.25f, 0.05f, 0.25f);
                HashSet<BlockPos> noLongerEyePositions = new HashSet<BlockPos>();
                for (BlockPos p : this.savedStates.keySet()) {
                    if (eyePositions.contains(p)) continue;
                    noLongerEyePositions.add(p);
                }
                for (BlockPos eyePosition : noLongerEyePositions) {
                    BlockState state = this.savedStates.get(eyePosition);
                    this.f_109059_.f_91073_.m_46597_(eyePosition, state);
                    this.savedStates.remove(eyePosition);
                }
                for (BlockPos p : eyePositions) {
                    BlockState stateAtP = this.f_109059_.f_91073_.m_8055_(p);
                    if (this.savedStates.containsKey(p) || this.f_109059_.f_91073_.m_46859_(p) || stateAtP.m_60734_() instanceof LiquidBlock) continue;
                    this.savedStates.put(p, stateAtP);
                    this.f_109059_.f_91073_.m_46597_(p, Blocks.f_50016_.m_49966_());
                }
                break block5;
            }
            if (this.savedStates.size() <= 0) break block5;
            HashSet<BlockPos> noLongerEyePositions = new HashSet<BlockPos>(this.savedStates.keySet());
            for (BlockPos eyePosition : noLongerEyePositions) {
                BlockState state = this.savedStates.get(eyePosition);
                this.f_109059_.f_91073_.m_46597_(eyePosition, state);
                this.savedStates.remove(eyePosition);
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V"), method={"renderWorld"})
    private void preventThirdPerson(Camera camera, BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        if (PowerHolderComponent.getPowers(camera.m_90592_(), PhasingPower.class).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS)) {
            camera.m_90575_(area, focusedEntity, false, false, tickDelta);
        } else {
            camera.m_90575_(area, focusedEntity, thirdPerson, inverseView, tickDelta);
        }
    }

    private Set<BlockPos> getEyePos(float rangeX, float rangeY, float rangeZ) {
        Vec3 pos = this.f_109054_.m_90592_().m_20182_().m_82520_(0.0, (double)this.f_109054_.m_90592_().m_20236_(this.f_109054_.m_90592_().m_20089_()), 0.0);
        AABB cameraBox = new AABB(pos, pos);
        cameraBox = cameraBox.m_82377_((double)rangeX, (double)rangeY, (double)rangeZ);
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        BlockPos.m_121921_((AABB)cameraBox).forEach(p -> set.add(p.m_7949_()));
        return set;
    }
}

