/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnLandPower;
import io.github.apace100.apoli.power.FireImmunityPower;
import io.github.apace100.apoli.power.GroundedPower;
import io.github.apace100.apoli.power.IgnoreWaterPower;
import io.github.apace100.apoli.power.InvisibilityPower;
import io.github.apace100.apoli.power.InvulnerablePower;
import io.github.apace100.apoli.power.ModifyVelocityPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.SwimmingPower;
import io.github.apace100.calio.Calio;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements MovingEntity,
SubmergableEntity {
    @Shadow
    public Level f_19853_;
    @Shadow
    public float f_19788_;
    @Shadow
    protected boolean f_19861_;
    @Shadow
    @Nullable
    protected Set<TagKey<Fluid>> f_19801_;
    @Shadow
    protected Object2DoubleMap<TagKey<Fluid>> f_19799_;
    private boolean isMoving;
    private float distanceBefore;

    @Inject(method={"isFireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((Entity)this, FireImmunityPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double m_204036_(TagKey<Fluid> var1);

    @Shadow
    public abstract Vec3 m_20184_();

    @Inject(method={"isTouchingWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((Entity)this, IgnoreWaterPower.class) && this instanceof WaterMovingEntity && ((WaterMovingEntity)((Object)this)).isInMovementPhase()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"fall"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onLandedUpon(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V")})
    private void invokeActionOnLand(CallbackInfo ci) {
        List<ActionOnLandPower> powers = PowerHolderComponent.getPowers((Entity)this, ActionOnLandPower.class);
        powers.forEach(ActionOnLandPower::executeAction);
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void makeOriginInvulnerable(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        PowerHolderComponent component;
        if (this instanceof LivingEntity && (component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this)).getPowers(InvulnerablePower.class).stream().anyMatch(inv -> inv.doesApply(damageSource))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(Entity entity) {
        if (PowerHolderComponent.hasPower(entity, SwimmingPower.class) && entity.m_6069_() && !(this.m_204036_((TagKey<Fluid>)FluidTags.f_13131_) > 0.0)) {
            return false;
        }
        return entity.m_20071_();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (PowerHolderComponent.hasPower((Entity)this, InvisibilityPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;ofFloored(DDD)Lnet/minecraft/util/math/BlockPos;")}, method={"pushOutOfBlocks"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        List<PhasingPower> powers = PowerHolderComponent.getPowers((Entity)this, PhasingPower.class);
        if (powers.size() > 0 && powers.stream().anyMatch(phasingPower -> phasingPower.doesApply(BlockPos.m_274561_((double)x, (double)y, (double)z)))) {
            info.cancel();
        }
    }

    @Redirect(method={"lambda$isInWall$8(Lnet/minecraft/world/phys/AABB;Lnet/minecraft/core/BlockPos;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getCollisionShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/shape/VoxelShape;"))
    private VoxelShape preventPhasingSuffocation(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60742_(world, pos, CollisionContext.m_82750_((Entity)((Entity)this)));
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(MoverType type, Vec3 movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.f_19788_;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    private void checkIsMoving(MoverType type, Vec3 movement, CallbackInfo ci) {
        if (this.f_19788_ > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private Vec3 modifyMovementVelocity(Vec3 original, MoverType movementType) {
        if (movementType != MoverType.SELF) {
            return original;
        }
        Vec3 modified = new Vec3(PowerHolderComponent.modify((Entity)this, ModifyVelocityPower.class, original.f_82479_, p -> p.axes.contains(Direction.Axis.X), null), PowerHolderComponent.modify((Entity)this, ModifyVelocityPower.class, original.f_82480_, p -> p.axes.contains(Direction.Axis.Y), null), PowerHolderComponent.modify((Entity)this, ModifyVelocityPower.class, original.f_82481_, p -> p.axes.contains(Direction.Axis.Z), null));
        return modified;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getLandingPos()Lnet/minecraft/util/math/BlockPos;")})
    private void forceGrounded(MoverType movementType, Vec3 movement, CallbackInfo ci) {
        if (PowerHolderComponent.hasPower((Entity)this, GroundedPower.class)) {
            this.f_19861_ = true;
        }
    }

    @Override
    public boolean isSubmergedInLoosely(TagKey<Fluid> tag) {
        if (tag == null || this.f_19801_ == null) {
            return false;
        }
        return this.f_19801_.contains(tag);
    }

    @Override
    public double getFluidHeightLoosely(TagKey<Fluid> tag) {
        if (tag == null) {
            return 0.0;
        }
        if (this.f_19799_.containsKey(tag)) {
            return this.f_19799_.getDouble(tag);
        }
        for (TagKey ft : this.f_19799_.keySet()) {
            if (!Calio.areTagsEqual((ResourceKey)Registries.f_256808_, (TagKey)ft, tag)) continue;
            return this.f_19799_.getDouble((Object)ft);
        }
        return 0.0;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

