/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.PowerCraftingInventory;
import io.github.apace100.apoli.power.ModifyCraftingPower;
import io.github.apace100.apoli.power.Power;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CraftingMenu.class})
public class CraftingScreenHandlerMixin {
    @Shadow
    @Final
    private ContainerLevelAccess f_39350_;
    @Shadow
    @Final
    private CraftingContainer f_39348_;

    @Inject(method={"updateResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/recipe/RecipeManager;getFirstMatch(Lnet/minecraft/recipe/RecipeType;Lnet/minecraft/inventory/Inventory;Lnet/minecraft/world/World;)Ljava/util/Optional;")})
    private static void clearPowerCraftingInventory(AbstractContainerMenu handler, Level world, Player player, CraftingContainer inventory, ResultContainer resultInventory, CallbackInfo ci) {
        if (inventory instanceof TransientCraftingContainer) {
            TransientCraftingContainer craftingInventory = (TransientCraftingContainer)inventory;
            ((PowerCraftingInventory)craftingInventory).setPower(null);
        }
    }

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowUsingViaPower(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)this.f_39350_.m_39299_((world, pos) -> pos.equals((Object)player.m_20183_()), (Object)false)).booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;copy()Lnet/minecraft/item/ItemStack;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void modifyOutputItems(Player player, int index, CallbackInfoReturnable<ItemStack> cir, ItemStack itemStack, Slot slot, ItemStack itemStack2) {
        PowerCraftingInventory pci;
        Power power;
        CraftingContainer craftingContainer = this.f_39348_;
        if (craftingContainer instanceof PowerCraftingInventory && (power = (pci = (PowerCraftingInventory)craftingContainer).getPower()) instanceof ModifyCraftingPower) {
            ModifyCraftingPower mcp = (ModifyCraftingPower)power;
            mcp.applyAfterCraftingItemAction(itemStack2);
        }
    }
}

