/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.authlib.GameProfile;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.IgnoreWaterPower;
import io.github.apace100.apoli.power.ModifyAirSpeedPower;
import io.github.apace100.apoli.power.PreventSprintingPower;
import io.github.apace100.apoli.power.SwimmingPower;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer
implements WaterMovingEntity {
    private boolean isMoving = false;
    @Shadow
    @Final
    public ClientPacketListener f_108617_;

    public ClientPlayerEntityMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(at={@At(value="HEAD")}, method={"isSubmergedInWater"}, cancellable=true)
    private void allowSwimming(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((Entity)this, SwimmingPower.class)) {
            cir.setReturnValue((Object)true);
        } else if (PowerHolderComponent.hasPower((Entity)this, IgnoreWaterPower.class)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickMovement"})
    private void beginMovementPhase(CallbackInfo ci) {
        this.isMoving = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"tickMovement"})
    private void endMovementPhase(CallbackInfo ci) {
        this.isMoving = false;
    }

    @Override
    public boolean isInMovementPhase() {
        return this.isMoving;
    }

    @Redirect(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerAbilities;getFlySpeed()F"))
    private float modifyFlySpeed(Abilities playerAbilities) {
        return PowerHolderComponent.modify((Entity)this, ModifyAirSpeedPower.class, playerAbilities.m_35942_());
    }

    @ModifyVariable(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;isOnGround()Z", ordinal=0), ordinal=4)
    private boolean modifySprintAbility(boolean original) {
        boolean prevent = PowerHolderComponent.hasPower((Entity)this, PreventSprintingPower.class);
        return !prevent && original;
    }
}

