/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyCameraSubmersionTypePower;
import io.github.apace100.apoli.power.NightVisionPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.util.MiscUtil;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FogRenderer.class})
@Environment(value=EnvType.CLIENT)
public abstract class BackgroundRendererMixin {
    @Shadow
    private static float f_109010_;
    @Shadow
    private static float f_109011_;
    @Shadow
    private static float f_109012_;

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=0), method={"render"})
    private static boolean hasStatusEffectProxy(LivingEntity player, MobEffect effect) {
        if (player instanceof Player && effect == MobEffects.f_19611_ && !player.m_21023_(MobEffects.f_19611_)) {
            return ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player)).getPowers(NightVisionPower.class).stream().anyMatch(Power::isActive);
        }
        return player.m_21023_(effect);
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;getFocusedEntity()Lnet/minecraft/entity/Entity;", ordinal=0), ordinal=0)
    private static FogType modifyCameraSubmersionTypeRender(FogType original, Camera camera) {
        if (camera.m_90592_() instanceof LivingEntity) {
            for (ModifyCameraSubmersionTypePower p : PowerHolderComponent.getPowers(camera.m_90592_(), ModifyCameraSubmersionTypePower.class)) {
                if (!p.doesModify(original)) continue;
                return p.getNewType();
            }
        }
        return original;
    }

    @ModifyVariable(method={"applyFog"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;getFocusedEntity()Lnet/minecraft/entity/Entity;", ordinal=0), ordinal=0)
    private static FogType modifyCameraSubmersionTypeFog(FogType original, Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog) {
        if (camera.m_90592_() instanceof LivingEntity) {
            for (ModifyCameraSubmersionTypePower p : PowerHolderComponent.getPowers(camera.m_90592_(), ModifyCameraSubmersionTypePower.class)) {
                if (!p.doesModify(original)) continue;
                return p.getNewType();
            }
        }
        return original;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/BackgroundRenderer;getFogModifier(Lnet/minecraft/entity/Entity;F)Lnet/minecraft/client/render/BackgroundRenderer$StatusEffectFogModifier;")})
    private static void modifyFogColor(Camera camera, float tickDelta, ClientLevel world, int viewDistance, float skyDarkness, CallbackInfo ci) {
        if (camera.m_90592_() instanceof LivingEntity && PowerHolderComponent.getPowers(camera.m_90592_(), PhasingPower.class).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && MiscUtil.getInWallBlockState((LivingEntity)((Player)camera.m_90592_())) != null) {
            f_109010_ = 0.0f;
            f_109011_ = 0.0f;
            f_109012_ = 0.0f;
        }
    }

    @Inject(method={"applyFog"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void modifyFogData(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo ci, FogType cameraSubmersionType, Entity entity, FogRenderer.FogData fogData) {
        List<PhasingPower> phasings;
        if (camera.m_90592_() instanceof LivingEntity && (phasings = PowerHolderComponent.getPowers(camera.m_90592_(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && MiscUtil.getInWallBlockState((LivingEntity)camera.m_90592_()) != null) {
            float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS).map(PhasingPower::getViewDistance).min(Float::compareTo).get().floatValue();
            if (fogData.f_234199_ == FogRenderer.FogMode.FOG_SKY) {
                fogData.f_234200_ = 0.0f;
                fogData.f_234201_ = view * 0.8f;
            } else {
                fogData.f_234200_ = view * 0.25f;
                fogData.f_234201_ = view;
            }
        }
    }
}

