/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.PreventBlockSelectionPower;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class AbstractBlockStateMixin {
    @Shadow
    public abstract Block m_60734_();

    @Shadow
    protected abstract BlockState m_7160_();

    @Shadow
    public abstract VoxelShape m_60808_(BlockGetter var1, BlockPos var2);

    @Inject(method={"getOutlineShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventBlockSelection(BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        Entity entity;
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).m_193113_() != null && PowerHolderComponent.getPowers(entity = ((EntityCollisionContext)context).m_193113_(), PreventBlockSelectionPower.class).stream().anyMatch(p -> p.doesPrevent((LevelReader)entity.m_9236_(), pos))) {
            cir.setReturnValue((Object)Shapes.m_83040_());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getCollisionShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"}, cancellable=true)
    private void phaseThroughBlocks(BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> info) {
        EntityCollisionContext esc;
        VoxelShape blockShape = (VoxelShape)info.getReturnValue();
        if (!blockShape.m_83281_() && context instanceof EntityCollisionContext && (esc = (EntityCollisionContext)context).m_193113_() != null) {
            Entity entity = esc.m_193113_();
            boolean isAbove = this.isAbove(entity, blockShape, pos, false);
            for (PhasingPower phasingPower : PowerHolderComponent.getPowers(entity, PhasingPower.class)) {
                if (isAbove && !phasingPower.shouldPhaseDown(entity) || !phasingPower.doesApply(pos)) continue;
                info.setReturnValue((Object)Shapes.m_83040_());
            }
        }
    }

    @Unique
    private boolean isAbove(Entity entity, VoxelShape shape, BlockPos pos, boolean defaultValue) {
        return entity.m_20186_() > (double)pos.m_123342_() + shape.m_83297_(Direction.Axis.Y) - (entity.m_20096_() ? 0.503125 : 0.0015);
    }

    @Inject(method={"onEntityCollision"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventCollisionWhenPhasing(Level world, BlockPos pos, Entity entity, CallbackInfo ci) {
        for (PhasingPower phasingPower : PowerHolderComponent.getPowers(entity, PhasingPower.class)) {
            if (!phasingPower.doesApply(pos)) continue;
            ci.cancel();
        }
    }
}

