/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.global;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.global.GlobalPowerSet;
import io.github.apace100.apoli.global.GlobalPowerSetUtil;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class GlobalPowerSetLoader
extends SimpleJsonResourceReloadListener
implements IdentifiableResourceReloadListener {
    public static final Set<ResourceLocation> DEPENDENCIES = Set.of(Apoli.identifier("powers"));
    public static List<GlobalPowerSet> ALL = new LinkedList<GlobalPowerSet>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public GlobalPowerSetLoader() {
        super(GSON, "global_powers");
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> GlobalPowerSetUtil.applyGlobalPowers(entity));
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ALL.clear();
        prepared.forEach((id, json) -> {
            if (json.isJsonObject()) {
                SerializableData.Instance data = GlobalPowerSet.DATA.read(json.getAsJsonObject());
                GlobalPowerSet gps = (GlobalPowerSet)GlobalPowerSet.FACTORY.fromData(data);
                List<PowerType<?>> invalidPowerTypes = gps.validate();
                if (invalidPowerTypes.size() > 0) {
                    Apoli.LOGGER.error("Global power set \"{}\" contained invalid powers: {}", id, (Object)invalidPowerTypes.stream().map(PowerType::getIdentifier).map(ResourceLocation::toString).collect(Collectors.joining(", ")));
                }
                ALL.add(gps);
            }
        });
        Apoli.LOGGER.info("Loaded " + ALL.size() + " global power sets.");
    }

    public ResourceLocation getFabricId() {
        return Apoli.identifier("global_powers");
    }

    public Collection<ResourceLocation> getFabricDependencies() {
        return DEPENDENCIES;
    }
}

