/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.component;

import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.util.GainedPowerCriterion;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PowerHolderComponentImpl
implements PowerHolderComponent {
    private final LivingEntity owner;
    private final ConcurrentHashMap<PowerType<?>, Power> powers = new ConcurrentHashMap();
    private final ConcurrentHashMap<PowerType<?>, List<ResourceLocation>> powerSources = new ConcurrentHashMap();

    public PowerHolderComponentImpl(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public boolean hasPower(PowerType<?> powerType) {
        return this.powers.containsKey(powerType);
    }

    @Override
    public boolean hasPower(PowerType<?> powerType, ResourceLocation source) {
        return this.powerSources.containsKey(powerType) && this.powerSources.get(powerType).contains(source);
    }

    @Override
    public <T extends Power> T getPower(PowerType<T> powerType) {
        if (this.powers.containsKey(powerType)) {
            return (T)this.powers.get(powerType);
        }
        return null;
    }

    @Override
    public List<Power> getPowers() {
        return new LinkedList<Power>(this.powers.values());
    }

    @Override
    public Set<PowerType<?>> getPowerTypes(boolean getSubPowerTypes) {
        HashSet powerTypes = new HashSet(this.powers.keySet());
        for (PowerType type : this.powers.keySet()) {
            if (getSubPowerTypes || !(type instanceof MultiplePowerType)) continue;
            ((MultiplePowerType)type).getSubPowers().stream().map(PowerTypeRegistry::get).forEach(powerTypes::remove);
        }
        return powerTypes;
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass) {
        return this.getPowers(powerClass, false);
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass, boolean includeInactive) {
        LinkedList<Power> list = new LinkedList<Power>();
        for (Power power : this.powers.values()) {
            if (!powerClass.isAssignableFrom(power.getClass()) || !includeInactive && !power.isActive()) continue;
            list.add(power);
        }
        return list;
    }

    @Override
    public List<ResourceLocation> getSources(PowerType<?> powerType) {
        if (this.powerSources.containsKey(powerType)) {
            return List.copyOf((Collection)this.powerSources.get(powerType));
        }
        return List.of();
    }

    @Override
    public void removePower(PowerType<?> powerType, ResourceLocation source) {
        if (powerType instanceof PowerTypeReference) {
            powerType = ((PowerTypeReference)powerType).getReferencedPowerType();
        }
        if (this.powerSources.containsKey(powerType)) {
            List<ResourceLocation> sources = this.powerSources.get(powerType);
            sources.remove(source);
            if (sources.isEmpty()) {
                this.powerSources.remove(powerType);
                Power power = this.powers.remove(powerType);
                if (power != null) {
                    power.onRemoved();
                    power.onLost();
                }
            }
            if (powerType instanceof MultiplePowerType) {
                ImmutableList<ResourceLocation> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                for (ResourceLocation subPowerId : subPowers) {
                    this.removePower(PowerTypeRegistry.get(subPowerId), source);
                }
            }
        }
    }

    @Override
    public int removeAllPowersFromSource(ResourceLocation source) {
        List<PowerType<?>> powersToRemove = this.getPowersFromSource(source);
        powersToRemove.forEach(p -> this.removePower((PowerType<?>)p, source));
        return powersToRemove.size();
    }

    @Override
    public List<PowerType<?>> getPowersFromSource(ResourceLocation source) {
        LinkedList powers = new LinkedList();
        for (Map.Entry<PowerType<?>, List<ResourceLocation>> sourceEntry : this.powerSources.entrySet()) {
            if (!sourceEntry.getValue().contains(source)) continue;
            powers.add(sourceEntry.getKey());
        }
        return powers;
    }

    @Override
    public boolean addPower(PowerType<?> powerType, ResourceLocation source) {
        if (powerType instanceof PowerTypeReference) {
            powerType = ((PowerTypeReference)powerType).getReferencedPowerType();
        }
        if (this.powerSources.containsKey(powerType)) {
            List<ResourceLocation> sources = this.powerSources.get(powerType);
            if (sources.contains(source)) {
                return false;
            }
            sources.add(source);
            if (powerType instanceof MultiplePowerType) {
                ImmutableList<ResourceLocation> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                for (ResourceLocation subPowerId : subPowers) {
                    this.addPower(PowerTypeRegistry.get(subPowerId), source);
                }
            }
            return true;
        }
        LinkedList<ResourceLocation> sources = new LinkedList<ResourceLocation>();
        sources.add(source);
        if (powerType instanceof MultiplePowerType) {
            ImmutableList<ResourceLocation> subPowers = ((MultiplePowerType)powerType).getSubPowers();
            for (ResourceLocation subPowerId : subPowers) {
                this.addPower(PowerTypeRegistry.get(subPowerId), source);
            }
        }
        this.powerSources.put(powerType, sources);
        Object power = powerType.create(this.owner);
        this.powers.put(powerType, (Power)power);
        ((Power)power).onGained();
        ((Power)power).onAdded();
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)livingEntity;
            GainedPowerCriterion.INSTANCE.trigger(spe, powerType);
        }
        return true;
    }

    public void serverTick() {
        this.getPowers(Power.class, true).stream().filter(p -> p.shouldTick() && (p.shouldTickWhenInactive() || p.isActive())).forEach(Power::tick);
    }

    public void readFromNbt(CompoundTag compoundTag) {
        this.fromTag(compoundTag, true);
    }

    private void fromTag(CompoundTag compoundTag, boolean callPowerOnAdd) {
        block16: {
            try {
                if (this.owner == null) {
                    Apoli.LOGGER.error("Owner was null in PowerHolderComponent#fromTag!");
                }
                if (callPowerOnAdd) {
                    for (Power power : this.powers.values()) {
                        power.onRemoved();
                        power.onLost();
                    }
                }
                this.powers.clear();
                ListTag powerList = (ListTag)compoundTag.m_128423_("Powers");
                if (powerList == null) break block16;
                for (int i = 0; i < powerList.size(); ++i) {
                    CompoundTag powerTag = powerList.m_128728_(i);
                    ResourceLocation powerTypeId = ResourceLocation.m_135820_((String)powerTag.m_128461_("Type"));
                    if (callPowerOnAdd && PowerTypeRegistry.isDisabled(powerTypeId)) continue;
                    ListTag sources = (ListTag)powerTag.m_128423_("Sources");
                    LinkedList list = new LinkedList();
                    if (sources != null) {
                        sources.forEach(nbtElement -> list.add(ResourceLocation.m_135820_((String)nbtElement.m_7916_())));
                    }
                    PowerType type = PowerTypeRegistry.get(powerTypeId);
                    this.powerSources.put(type, list);
                    try {
                        Tag data = powerTag.m_128423_("Data");
                        Object power = type.create(this.owner);
                        try {
                            ((Power)power).fromTag(data);
                        }
                        catch (ClassCastException e) {
                            Apoli.LOGGER.warn("Data type of \"" + String.valueOf(powerTypeId) + "\" changed, skipping data for that power on entity " + this.owner.m_7755_().getString());
                        }
                        this.powers.put(type, (Power)power);
                        if (!callPowerOnAdd) continue;
                        ((Power)power).onAdded();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Apoli.LOGGER.warn("Power data of unregistered power \"" + String.valueOf(powerTypeId) + "\" found on entity, skipping...");
                    }
                }
                for (Map.Entry<PowerType<?>, List<ResourceLocation>> entry : this.powerSources.entrySet()) {
                    PowerType<?> powerType = entry.getKey();
                    if (!(powerType instanceof MultiplePowerType)) continue;
                    ImmutableList<ResourceLocation> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                    for (ResourceLocation subPowerId : subPowers) {
                        try {
                            PowerType subType = PowerTypeRegistry.get(subPowerId);
                            for (ResourceLocation source : entry.getValue()) {
                                if (this.hasPower(subType, source)) continue;
                                this.addPower(subType, source);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (callPowerOnAdd && PowerTypeRegistry.isDisabled(subPowerId)) continue;
                            Apoli.LOGGER.warn("Multiple power type read from data contained unregistered sub-type: \"" + String.valueOf(subPowerId) + "\".");
                        }
                    }
                }
            }
            catch (Exception e) {
                Apoli.LOGGER.error("Error while reading power holder data: " + e.getMessage());
            }
        }
    }

    public void writeToNbt(CompoundTag compoundTag) {
        ListTag powerList = new ListTag();
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            CompoundTag powerTag = new CompoundTag();
            powerTag.m_128359_("Type", PowerTypeRegistry.getId(powerEntry.getKey()).toString());
            powerTag.m_128365_("Data", powerEntry.getValue().toTag());
            ListTag sources = new ListTag();
            this.powerSources.get(powerEntry.getKey()).forEach(id -> sources.add((Object)StringTag.m_129297_((String)id.toString())));
            powerTag.m_128365_("Sources", (Tag)sources);
            powerList.add((Object)powerTag);
        }
        compoundTag.m_128365_("Powers", (Tag)powerList);
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        CompoundTag compoundTag = buf.m_130260_();
        if (compoundTag != null) {
            this.fromTag(compoundTag, false);
        }
    }

    @Override
    public void sync() {
        PowerHolderComponent.sync((Entity)this.owner);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("PowerHolderComponent[\n");
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            str.append("\t").append(PowerTypeRegistry.getId(powerEntry.getKey())).append(": ").append(powerEntry.getValue().toTag().toString()).append("\n");
        }
        str.append("]");
        return str.toString();
    }
}

