/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PowerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"power").requires(scs -> scs.m_6761_(2))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.grantPower((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"source", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> PowerCommand.grantPower((CommandContext<CommandSourceStack>)context, true))))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.revokePower((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"source", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> PowerCommand.revokePower((CommandContext<CommandSourceStack>)context, true))))))).then(Commands.m_82127_((String)"revokeall").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"source", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(PowerCommand::revokeAllPowers))))).then(Commands.m_82127_((String)"list").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> PowerCommand.listPowers((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"subpowers", (ArgumentType)BoolArgumentType.bool()).executes(context -> PowerCommand.listPowers((CommandContext<CommandSourceStack>)context, true)))))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::hasPower))))).then(Commands.m_82127_((String)"sources").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::getSourcesFromPower))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::removePower))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(PowerCommand::clearAllPowers))));
    }

    private static int grantPower(CommandContext<CommandSourceStack> context, boolean isSourceSpecified) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        ResourceLocation powerSource = isSourceSpecified ? ResourceLocationArgument.m_107011_(context, (String)"source") : Apoli.identifier("command");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            if (!powerHolderComponent.addPower(powerType, powerSource)) continue;
            powerHolderComponent.sync();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (isSourceSpecified) {
                if (processedLivingTargets.size() == 1) {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), powerType.getName()}), true);
                } else {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName()}), true);
                }
            } else if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant_from_source.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), powerType.getName(), powerSource}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant_from_source.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName(), powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), powerType.getName(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.fail.multiple", (Object[])new Object[]{livingTargets.size(), powerType.getName(), powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int revokePower(CommandContext<CommandSourceStack> context, boolean isSourceSpecified) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        ResourceLocation powerSource = isSourceSpecified ? ResourceLocationArgument.m_107011_(context, (String)"source") : Apoli.identifier("command");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            if (!powerHolderComponent.hasPower(powerType, powerSource)) continue;
            powerHolderComponent.removePower(powerType, powerSource);
            powerHolderComponent.sync();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (!isSourceSpecified) {
                if (processedLivingTargets.size() == 1) {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), powerType.getName()}), true);
                } else {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName()}), true);
                }
            } else if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_from_source.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), powerType.getName(), powerSource}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_from_source.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName(), powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), powerType.getName(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.fail.multiple", (Object[])new Object[]{powerType.getName(), powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.invalid_entities", (Object[])new Object[]{nonLivingTargets.size(), powerSource}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int revokeAllPowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceLocation powerSource = ResourceLocationArgument.m_107011_(context, (String)"source");
        int revokedPowers = 0;
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)target);
            int i = powerHolderComponent.removeAllPowersFromSource(powerSource);
            if (i <= 0) continue;
            powerHolderComponent.sync();
            revokedPowers += i;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            int currentRevokedPowers = revokedPowers;
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_all.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), currentRevokedPowers, powerSource}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_all.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), currentRevokedPowers, powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.fail.multiple", (Object[])new Object[]{powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.invalid_entities", (Object[])new Object[]{nonLivingTargets.size(), powerSource}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int listPowers(CommandContext<CommandSourceStack> context, boolean includeSubpowers) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity target = EntityArgument.m_91452_(context, (String)"target");
        LinkedList<MutableComponent> powers = new LinkedList<MutableComponent>();
        int powerCount = 0;
        if (!(target instanceof LivingEntity)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.list.fail", (Object[])new Object[]{target.m_5446_()}));
            return powerCount;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
        for (PowerType<?> powerType : powerHolderComponent.getPowerTypes(includeSubpowers)) {
            LinkedList powerSources = new LinkedList();
            powerHolderComponent.getSources(powerType).forEach(powerSource -> powerSources.add(Component.m_130674_((String)powerSource.toString())));
            HoverEvent powerSourcesOnHover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)(powerSources.size() == 1 ? "commands.apoli.list.source" : "commands.apoli.list.sources"), (Object[])new Object[]{ComponentUtils.m_178433_(powerSources, (Component)Component.m_130674_((String)", "))}));
            MutableComponent power = Component.m_237113_((String)powerType.getIdentifier().toString()).m_6270_(Style.f_131099_.m_131144_(powerSourcesOnHover));
            powers.add(power);
            ++powerCount;
        }
        if (powerCount > 0) {
            int currentPowerCount = powerCount;
            source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.list.pass", (Object[])new Object[]{livingTarget.m_5446_(), currentPowerCount, ComponentUtils.m_178433_((Collection)powers, (Component)Component.m_130674_((String)", "))}), true);
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.list.fail", (Object[])new Object[]{livingTarget.m_5446_()}));
        }
        return powerCount;
    }

    private static int hasPower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            LivingEntity livingTarget;
            PowerHolderComponent powerHolderComponent;
            if (!(target instanceof LivingEntity) || !(powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)(livingTarget = (LivingEntity)target))).hasPower(powerType)) continue;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{processedLivingTargets.size()}), true);
            }
        } else if (targets.size() == 1) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.execute.conditional.fail"));
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.execute.conditional.fail_count", (Object[])new Object[]{targets.size()}));
        }
        return processedLivingTargets.size();
    }

    private static int getSourcesFromPower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity target = EntityArgument.m_91452_(context, (String)"target");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        StringBuilder powerSources = new StringBuilder();
        int powerSourceCount = 0;
        if (!(target instanceof LivingEntity)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.sources.fail", (Object[])new Object[]{target.m_5446_(), powerType.getName()}));
            return powerSourceCount;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
        for (ResourceLocation powerSource : powerHolderComponent.getSources(powerType)) {
            if (powerSourceCount > 0) {
                powerSources.append(", ");
            }
            powerSources.append(powerSource.toString());
            ++powerSourceCount;
        }
        if (powerSourceCount > 0) {
            int currentPowerSourceCount = powerSourceCount;
            source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.sources.pass", (Object[])new Object[]{livingTarget.m_5446_(), currentPowerSourceCount, powerType.getName(), powerSources}), true);
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.sources.fail", (Object[])new Object[]{livingTarget.m_5446_(), powerType.getName()}));
        }
        return powerSourceCount;
    }

    private static int removePower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            List<ResourceLocation> powerSources = powerHolderComponent.getSources(powerType);
            if (powerSources.isEmpty()) continue;
            for (ResourceLocation powerSource : powerSources) {
                powerHolderComponent.removePower(powerType, powerSource);
            }
            powerHolderComponent.sync();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.remove.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), powerType.getName()}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.remove.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerType.getName()}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), powerType.getName()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.fail.multiple", (Object[])new Object[]{powerType.getName()}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int clearAllPowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        int clearedPowers = 0;
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingTarget);
            Set<PowerType<?>> powerTypes = powerHolderComponent.getPowerTypes(false);
            if (powerTypes.isEmpty()) continue;
            for (PowerType<?> powerType : powerTypes) {
                List<ResourceLocation> powerSources = powerHolderComponent.getSources(powerType);
                powerSources.forEach(powerHolderComponent::removeAllPowersFromSource);
            }
            powerHolderComponent.sync();
            clearedPowers += powerTypes.size();
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            int currentClearedPowers = clearedPowers;
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.clear.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), currentClearedPowers}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.clear.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), currentClearedPowers}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.clear.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"commands.apoli.clear.fail.multiple"));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.clear.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.clear.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return clearedPowers;
    }
}

