/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.networking.ModPacketsS2C;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.factory.condition.EntityConditionsClient;
import io.github.apace100.apoli.power.factory.condition.ItemConditionsClient;
import io.github.apace100.apoli.registry.ApoliClassDataClient;
import io.github.apace100.apoli.screen.GameHudRender;
import io.github.apace100.apoli.screen.PowerHudRenderer;
import io.github.apace100.apoli.util.ApoliConfig;
import io.github.apace100.apoli.util.ApoliConfigClient;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class ApoliClient
implements ClientModInitializer {
    public static boolean shouldReloadWorldRenderer = false;
    private static HashMap<String, KeyMapping> idToKeyBindingMap = new HashMap();
    private static HashMap<String, Boolean> lastKeyBindingStates = new HashMap();
    private static boolean initializedKeyBindingMap = false;

    public static void registerPowerKeybinding(String keyId, KeyMapping keyBinding) {
        idToKeyBindingMap.put(keyId, keyBinding);
    }

    public void onInitializeClient() {
        ModPacketsS2C.register();
        ApoliClassDataClient.registerAll();
        EntityConditionsClient.register();
        ItemConditionsClient.register();
        ClientTickEvents.START_CLIENT_TICK.register(tick -> {
            if (tick.f_91074_ != null) {
                List<Power> powers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)tick.f_91074_)).getPowers();
                LinkedList<Power> pressedPowers = new LinkedList<Power>();
                HashMap<String, Boolean> currentKeyBindingStates = new HashMap<String, Boolean>();
                for (Power power : powers) {
                    if (!(power instanceof Active)) continue;
                    Active active = (Active)((Object)power);
                    Active.Key key = active.getKey();
                    KeyMapping keyBinding = this.getKeyBinding(key.key);
                    if (keyBinding == null) continue;
                    if (!currentKeyBindingStates.containsKey(key.key)) {
                        currentKeyBindingStates.put(key.key, keyBinding.m_90857_());
                    }
                    if (!((Boolean)currentKeyBindingStates.get(key.key)).booleanValue() || !key.continuous && lastKeyBindingStates.getOrDefault(key.key, false).booleanValue()) continue;
                    pressedPowers.add(power);
                }
                lastKeyBindingStates = currentKeyBindingStates;
                if (pressedPowers.size() > 0) {
                    this.performActivePowers(pressedPowers);
                }
            }
        });
        GameHudRender.HUD_RENDERS.add(new PowerHudRenderer());
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            for (GameHudRender hudRender : GameHudRender.HUD_RENDERS) {
                hudRender.render(drawContext, tickDelta);
            }
        });
        AutoConfig.register(ApoliConfigClient.class, JanksonConfigSerializer::new);
        Apoli.config = (ApoliConfig)AutoConfig.getConfigHolder(ApoliConfigClient.class).getConfig();
    }

    @Environment(value=EnvType.CLIENT)
    private void performActivePowers(List<Power> powers) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(powers.size());
        for (Power power : powers) {
            buffer.m_130085_(power.getType().getIdentifier());
            ((Active)((Object)power)).onUse();
        }
        ClientPlayNetworking.send((ResourceLocation)ModPackets.USE_ACTIVE_POWERS, (FriendlyByteBuf)buffer);
    }

    @Environment(value=EnvType.CLIENT)
    private KeyMapping getKeyBinding(String key) {
        if (!idToKeyBindingMap.containsKey(key)) {
            if (!initializedKeyBindingMap) {
                initializedKeyBindingMap = true;
                Minecraft client = Minecraft.m_91087_();
                for (int i = 0; i < client.f_91066_.f_92059_.length; ++i) {
                    idToKeyBindingMap.put(client.f_91066_.f_92059_[i].m_90860_(), client.f_91066_.f_92059_[i]);
                }
                return this.getKeyBinding(key);
            }
            return null;
        }
        return idToKeyBindingMap.get(key);
    }
}

